/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import se.bjurr.violations.lib.model.Violation;

public class Utils {
    public static <T> T checkNotNull(T reference, String errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage);
        }
        return reference;
    }

    public static String emptyToNull(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        return str;
    }

    public static String nullToEmpty(String nullableReference) {
        return nullableReference == null ? "" : nullableReference;
    }

    public static <T> T firstNonNull(T f, T s) {
        if (f != null) {
            return f;
        }
        return s;
    }

    public static InputStream getResource(String filename) {
        Thread.currentThread().getContextClassLoader();
        return ClassLoader.getSystemResourceAsStream(filename);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String toString(InputStream inputStream) throws IOException {
        Scanner scanner = new Scanner(inputStream, "UTF-8").useDelimiter("\\A");
        String result = scanner.hasNext() ? scanner.next() : "";
        scanner.close();
        inputStream.close();
        return result;
    }

    public static String toString(URL resource) throws IOException {
        return Utils.toString(resource.openStream());
    }

    public static List<Violation> setReporter(List<Violation> violations, String reporter) {
        for (Violation v : violations) {
            v.setReporter(reporter);
        }
        return violations;
    }
}

