/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class CPPCheckParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<String> errorChunks = ViolationParserUtils.getChunks(string, "<error", "</error>");
        for (String errorChunk : errorChunks) {
            String severity = ViolationParserUtils.getAttribute(errorChunk, "severity");
            String msg = ViolationParserUtils.getAttribute(errorChunk, "msg");
            String verbose = ViolationParserUtils.getAttribute(errorChunk, "verbose");
            String id = ViolationParserUtils.getAttribute(errorChunk, "id");
            List<String> locationChunks = ViolationParserUtils.getChunks(errorChunk, "<location", "/>");
            for (String locationChunk : locationChunks) {
                Integer line = ViolationParserUtils.getIntegerAttribute(locationChunk, "line");
                Optional<String> info = ViolationParserUtils.findAttribute(locationChunk, "info");
                String fileString = ViolationParserUtils.getAttribute(errorChunk, "file");
                String message = "";
                message = verbose.startsWith(msg) ? verbose : msg + ". " + verbose;
                if (info.isPresent() && !message.contains(info.get())) {
                    message = message + ". " + info.get();
                }
                violations.add(Violation.violationBuilder().setParser(Parser.CPPCHECK).setStartLine(line).setFile(fileString).setSeverity(this.toSeverity(severity)).setMessage(message).setRule(id).build());
            }
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("error")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("warning")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

