/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class IARParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String reportContent) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<List<String>> partsPerLine = ViolationParserUtils.getLines(reportContent, "\"([^\"]+)\",(\\d+)([^\\[]*)\\[([^\\]]*)\\]:(.*)");
        for (List<String> parts : partsPerLine) {
            String fileName = parts.get(1).trim();
            Integer lineNumber = Integer.parseInt(parts.get(2));
            Integer columnNumber = 0;
            String severity = parts.get(3).toLowerCase().trim();
            String rule = parts.get(4).trim();
            String message = parts.get(5).trim();
            violations.add(Violation.violationBuilder().setParser(Parser.IAR).setStartLine(lineNumber).setColumn(columnNumber).setFile(fileName).setSeverity(this.toSeverity(severity)).setRule(rule).setMessage(message).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (Utils.isNullOrEmpty(severity) || severity.contains("info")) {
            return SEVERITY.INFO;
        }
        if (severity.contains("error")) {
            return SEVERITY.ERROR;
        }
        if (severity.contains("warning")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

