/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;

public class KlocworkParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes("UTF-8"));){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlr = factory.createXMLStreamReader(input);
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1 || !xmlr.getLocalName().equalsIgnoreCase("problem")) continue;
                violations.add(this.parseBug(xmlr));
            }
        }
        return violations;
    }

    private Violation parseBug(XMLStreamReader xmlr) throws XMLStreamException {
        int eventType;
        String file = null;
        String message = null;
        String code = null;
        Integer severitylevel = null;
        String method = null;
        String url = null;
        while (xmlr.hasNext() && ((eventType = xmlr.next()) != 2 || !xmlr.getLocalName().equalsIgnoreCase("problem"))) {
            if (eventType != 1) continue;
            if (xmlr.getLocalName().equalsIgnoreCase("file")) {
                file = xmlr.getElementText();
            }
            if (xmlr.getLocalName().equalsIgnoreCase("message")) {
                message = xmlr.getElementText();
            }
            if (xmlr.getLocalName().equalsIgnoreCase("code")) {
                code = xmlr.getElementText();
            }
            if (xmlr.getLocalName().equalsIgnoreCase("severitylevel")) {
                severitylevel = Integer.parseInt(xmlr.getElementText());
            }
            if (xmlr.getLocalName().equalsIgnoreCase("method")) {
                method = xmlr.getElementText();
            }
            if (!xmlr.getLocalName().equalsIgnoreCase("url")) continue;
            url = xmlr.getElementText();
        }
        return Violation.violationBuilder().setParser(Parser.KLOCWORK).setFile(file).setMessage("In method " + method + ". " + message + " " + url).setRule(code).setSeverity(this.getSeverity(severitylevel)).setStartLine(1).build();
    }

    private SEVERITY getSeverity(Integer from) {
        if (from <= 2) {
            return SEVERITY.ERROR;
        }
        if (from <= 3) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

