/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class LintParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<String> files = ViolationParserUtils.getChunks(string, "<file", "</file>");
        for (String fileChunk : files) {
            String filename = ViolationParserUtils.getAttribute(fileChunk, "name");
            List<String> issues = ViolationParserUtils.getChunks(fileChunk, "<issue", "/>");
            for (String issueChunk : issues) {
                Integer line = ViolationParserUtils.getIntegerAttribute(issueChunk, "line");
                Optional<Integer> charAttrib = ViolationParserUtils.findIntegerAttribute(issueChunk, "char");
                String severity = ViolationParserUtils.getAttribute(issueChunk, "severity");
                String message = ViolationParserUtils.getAttribute(issueChunk, "reason");
                String evidence = ViolationParserUtils.getAttribute(issueChunk, "evidence").trim();
                violations.add(Violation.violationBuilder().setParser(Parser.LINT).setStartLine(line).setColumn(charAttrib.orElse(null)).setFile(filename).setSeverity(this.toSeverity(severity)).setMessage(message + ": " + evidence).build());
            }
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("ERROR")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("WARNING")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

