/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import se.bjurr.violations.git.ViolationsGit;
import se.bjurr.violations.git.ViolationsReporterApi;
import se.bjurr.violations.git.ViolationsReporterDetailLevel;
import se.bjurr.violations.lib.ViolationsApi;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.model.codeclimate.CodeClimateTransformer;
import se.bjurr.violations.lib.util.Filtering;
import se.bjurr.violations.maven.plugin.ViolationConfig;
import se.bjurr.violations.violationslib.com.google.gson.GsonBuilder;

@Mojo(name="violations", defaultPhase=LifecyclePhase.VERIFY)
public class ViolationCommentsMojo
extends AbstractMojo {
    @Parameter(property="printViolations", required=false, defaultValue="true")
    private boolean printViolations;
    @Parameter(property="violations", required=true)
    private List<ViolationConfig> violations;
    @Parameter(property="minSeverity", required=false, defaultValue="INFO")
    private SEVERITY minSeverity;
    @Parameter(property="detailLevel", required=false, defaultValue="VERBOSE")
    private ViolationsReporterDetailLevel detailLevel;
    @Parameter(property="maxViolations", required=false, defaultValue="999999")
    private Integer maxViolations;
    @Parameter(property="diffPrintViolations", required=false, defaultValue="false")
    private boolean diffPrintViolations;
    @Parameter(property="diffFrom", required=false)
    private String diffFrom;
    @Parameter(property="diffTo", required=false)
    private String diffTo;
    @Parameter(property="diffMinSeverity", required=false, defaultValue="INFO")
    private SEVERITY diffMinSeverity;
    @Parameter(property="diffMaxViolations", required=false, defaultValue="999999")
    private Integer diffMaxViolations;
    @Parameter(property="diffDetailLevel", required=false, defaultValue="VERBOSE")
    private ViolationsReporterDetailLevel diffDetailLevel;
    @Parameter(property="gitRepo", required=false, defaultValue=".")
    private File gitRepo;
    @Parameter(property="maxLineColumnWidth", required=false, defaultValue="0")
    private int maxLineColumnWidth;
    @Parameter(property="maxMessageColumnWidth", required=false, defaultValue="30")
    private int maxMessageColumnWidth;
    @Parameter(property="maxReporterColumnWidth", required=false, defaultValue="0")
    private int maxReporterColumnWidth;
    @Parameter(property="maxRuleColumnWidth", required=false, defaultValue="0")
    private int maxRuleColumnWidth;
    @Parameter(property="maxSeverityColumnWidth", required=false, defaultValue="0")
    private int maxSeverityColumnWidth;
    @Parameter(property="codeClimateFile", required=false)
    private File codeClimateFile;
    @Parameter(property="violationsFile", required=false)
    private File violationsFile;

    public void setPrintViolations(boolean printViolations) {
        this.printViolations = printViolations;
    }

    public void setDetailLevel(ViolationsReporterDetailLevel detailLevel) {
        this.detailLevel = detailLevel;
    }

    public void setMaxViolations(Integer maxViolations) {
        this.maxViolations = maxViolations;
    }

    public void setViolations(List<ViolationConfig> violations) {
        this.violations = violations;
    }

    public void execute() throws MojoExecutionException {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void doExecute() throws Exception, ScriptException {
        ArrayList<Violation> allParsedViolations = new ArrayList<Violation>();
        ArrayList<Violation> allParsedViolationsInDiff = new ArrayList<Violation>();
        for (ViolationConfig configuredViolation : this.violations) {
            List parsedViolations = ViolationsApi.violationsApi().findAll(configuredViolation.getParser()).inFolder(configuredViolation.getFolder()).withPattern(configuredViolation.getPattern()).withReporter(configuredViolation.getReporter()).violations();
            allParsedViolations.addAll(this.getFiltered(parsedViolations, this.minSeverity));
            if (this.shouldCheckDiff()) {
                allParsedViolationsInDiff.addAll(this.getAllViolationsInDiff(parsedViolations));
                continue;
            }
            this.getLog().debug((CharSequence)"No references specified, will not report violations in diff");
        }
        if (this.codeClimateFile != null) {
            this.createJsonFile(CodeClimateTransformer.fromViolations(allParsedViolations), this.codeClimateFile);
        }
        if (this.violationsFile != null) {
            this.createJsonFile(allParsedViolations, this.violationsFile);
        }
        this.checkGlobalViolations(allParsedViolations);
        if (this.shouldCheckDiff()) {
            this.checkDiffViolations(allParsedViolationsInDiff);
        }
    }

    private void createJsonFile(Object object, File file) throws IOException {
        String codeClimateReport = new GsonBuilder().setPrettyPrinting().create().toJson(object);
        Files.write(file.toPath(), codeClimateReport.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }

    private void checkGlobalViolations(List<Violation> violations) throws ScriptException {
        boolean tooManyViolations;
        boolean bl = tooManyViolations = violations.size() > this.maxViolations;
        if (!tooManyViolations && !this.printViolations) {
            return;
        }
        String report = ViolationsReporterApi.violationsReporterApi().withViolations(violations).withMaxLineColumnWidth(this.maxLineColumnWidth).withMaxMessageColumnWidth(this.maxMessageColumnWidth).withMaxReporterColumnWidth(this.maxReporterColumnWidth).withMaxRuleColumnWidth(this.maxRuleColumnWidth).withMaxSeverityColumnWidth(this.maxSeverityColumnWidth).getReport(this.detailLevel);
        if (tooManyViolations) {
            throw new ScriptException("Too many violations found, max is " + this.maxViolations + " but found " + violations.size() + "\n" + report);
        }
        if (this.printViolations) {
            this.getLog().info((CharSequence)("\nViolations in repo\n\n" + report));
        }
    }

    private void checkDiffViolations(List<Violation> violations) throws ScriptException {
        boolean tooManyViolations;
        boolean bl = tooManyViolations = violations.size() > this.diffMaxViolations;
        if (!tooManyViolations && !this.diffPrintViolations) {
            return;
        }
        String report = ViolationsReporterApi.violationsReporterApi().withViolations(violations).withMaxLineColumnWidth(this.maxLineColumnWidth).withMaxMessageColumnWidth(this.maxMessageColumnWidth).withMaxReporterColumnWidth(this.maxReporterColumnWidth).withMaxRuleColumnWidth(this.maxRuleColumnWidth).withMaxSeverityColumnWidth(this.maxSeverityColumnWidth).getReport(this.diffDetailLevel);
        if (tooManyViolations) {
            throw new ScriptException("Too many violations found in diff, max is " + this.diffMaxViolations + " but found " + violations.size() + "\n" + report);
        }
        if (this.diffPrintViolations) {
            this.getLog().info((CharSequence)("\nViolations in diff\n\n" + report));
        }
    }

    private List<Violation> getAllViolationsInDiff(List<Violation> unfilteredViolations) throws Exception {
        List<Violation> candidates = this.getFiltered(unfilteredViolations, this.diffMinSeverity);
        return new ViolationsGit(candidates).getViolationsInChangeset(this.gitRepo, this.diffFrom, this.diffTo);
    }

    private boolean shouldCheckDiff() {
        return this.isDefined(this.diffFrom) && this.isDefined(this.diffTo);
    }

    private List<Violation> getFiltered(List<Violation> unfiltered, SEVERITY filter) {
        if (filter != null) {
            return Filtering.withAtLEastSeverity(unfiltered, (SEVERITY)filter);
        }
        return unfiltered;
    }

    private boolean isDefined(String str) {
        return str != null && !str.isEmpty();
    }
}

