/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.wiremockpact.wiremockpactlib.api;

import java.util.ArrayList;
import java.util.List;

public class WireMockPactConfig {
    private String pactJsonFolder = "pact-json";
    private String providerDefaultValue = "the-provider";
    private List<String> providerStatesDefaultValue = new ArrayList<String>();
    private String consumerDefaultValue = "the-consumer";
    private String includeRequestHeadersRegexp = "^(?!Host|User-Agent|Connection$).*";
    private String includeResponseHeadersRegexp = "^(?!Matched-Stub-Id$).*";

    public static WireMockPactConfig builder() {
        return new WireMockPactConfig();
    }

    public WireMockPactConfig setConsumerDefaultValue(String value) {
        this.consumerDefaultValue = value;
        return this;
    }

    public WireMockPactConfig setProviderDefaultValue(String value) {
        this.providerDefaultValue = value;
        return this;
    }

    public WireMockPactConfig setPactJsonFolder(String value) {
        this.pactJsonFolder = value;
        return this;
    }

    public WireMockPactConfig setIncludeRequestHeadersRegexp(String includeRequestHeadersRegexp) {
        this.includeRequestHeadersRegexp = includeRequestHeadersRegexp;
        return this;
    }

    public WireMockPactConfig setIncludeResponseHeadersRegexp(String includeResponseHeadersRegexp) {
        this.includeResponseHeadersRegexp = includeResponseHeadersRegexp;
        return this;
    }

    public WireMockPactConfig setProviderStatesDefaultValue(List<String> providerStatesDefaultValue) {
        this.providerStatesDefaultValue = providerStatesDefaultValue;
        return this;
    }

    public List<String> getProviderStatesDefaultValue() {
        return this.providerStatesDefaultValue;
    }

    public String getConsumerDefaultValue() {
        return this.consumerDefaultValue;
    }

    public String getPactJsonFolder() {
        return this.pactJsonFolder;
    }

    public String getProviderDefaultValue() {
        return this.providerDefaultValue;
    }

    public String getIncludeRequestHeadersRegexp() {
        return this.includeRequestHeadersRegexp;
    }

    public String getIncludeResponseHeadersRegexp() {
        return this.includeResponseHeadersRegexp;
    }

    public String toString() {
        return "WireMockPactConfig [pactJsonFolder=" + this.pactJsonFolder + ", providerDefaultValue=" + this.providerDefaultValue + ", providerStatesDefaultValue=" + String.valueOf(this.providerStatesDefaultValue) + ", consumerDefaultValue=" + this.consumerDefaultValue + ", includeRequestHeadersRegexp=" + this.includeRequestHeadersRegexp + ", includeResponseHeadersRegexp=" + this.includeResponseHeadersRegexp + "]";
    }
}

