/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.wiremockpact.wiremockpactlib.api;

import au.com.dius.pact.core.model.Consumer;
import au.com.dius.pact.core.model.IRequest;
import au.com.dius.pact.core.model.IResponse;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.Provider;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.model.SynchronousRequestResponse;
import au.com.dius.pact.core.model.V4Interaction;
import au.com.dius.pact.core.model.V4Pact;
import com.github.tomakehurst.wiremock.common.Metadata;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.LoggedResponse;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import se.bjurr.wiremockpact.wiremockpactlib.api.WireMockPactConfig;
import se.bjurr.wiremockpact.wiremockpactlib.api.model.WireMockPactMetadata;
import se.bjurr.wiremockpact.wiremockpactlib.internal.JsonHelper;

public final class WireMockPactApi {
    private static final Logger LOG = Logger.getLogger(WireMockPactApi.class.getSimpleName());
    private final WireMockPactConfig config;
    private final List<ServeEvent> serveEvents = new ArrayList<ServeEvent>();

    private WireMockPactApi(WireMockPactConfig config) {
        this.config = config;
    }

    public static WireMockPactApi create(WireMockPactConfig config) {
        return new WireMockPactApi(config);
    }

    public void addServeEvent(ServeEvent serveEvent) {
        this.serveEvents.add(serveEvent);
    }

    public void saveAll() {
        LOG.info("Saving " + this.serveEvents.size() + " serveevents to " + this.getAbsoluteJsonFolder());
        Consumer consumer = new Consumer(this.config.getConsumerDefaultValue());
        String defaultProvider = this.config.getProviderDefaultValue();
        TreeMap interactionsPerProvider = new TreeMap();
        for (ServeEvent serveEvent : this.serveEvents) {
            WireMockPactMetadata wireMockMetadata = this.getMetadataModel(serveEvent);
            String provider = Optional.ofNullable(wireMockMetadata.getProvider()).orElse(defaultProvider);
            List<String> providerStates = this.getProviderStates(serveEvent, wireMockMetadata.getProviderStates());
            LoggedRequest wireMockRequest = serveEvent.getRequest();
            LoggedResponse wireMockResponse = serveEvent.getResponse();
            V4Interaction.SynchronousHttp interaction = new V4Interaction.SynchronousHttp(wireMockRequest.getMethod().getName() + " " + wireMockRequest.getUrl() + " -> " + wireMockResponse.getStatus());
            SynchronousRequestResponse asSynchronousRequestResponse = interaction.asSynchronousRequestResponse();
            interaction.getProviderStates().addAll(providerStates.stream().map(it -> new ProviderState(it)).toList());
            IRequest pactRequest = asSynchronousRequestResponse.getRequest();
            pactRequest.setMethod(wireMockRequest.getMethod().getName());
            pactRequest.setPath(Urls.getPath((String)wireMockRequest.getUrl()));
            pactRequest.getQuery().putAll(Urls.splitQueryFromUrl((String)wireMockRequest.getUrl()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((QueryParameter)e.getValue()).values())));
            pactRequest.setBody(new OptionalBody(OptionalBody.State.PRESENT, wireMockRequest.getBody()));
            for (HttpHeader header : Optional.ofNullable(wireMockRequest.getHeaders()).orElse(new HttpHeaders()).all()) {
                if (!header.getKey().matches(this.config.getIncludeRequestHeadersRegexp())) continue;
                pactRequest.getHeaders().put(header.getKey(), header.getValues());
            }
            if (!interactionsPerProvider.containsKey(provider)) {
                interactionsPerProvider.put(provider, new ArrayList());
            }
            IResponse pactResponse = asSynchronousRequestResponse.getResponse();
            pactResponse.setBody(new OptionalBody(OptionalBody.State.PRESENT, wireMockResponse.getBody()));
            pactResponse.setStatus(wireMockResponse.getStatus());
            for (HttpHeader header : Optional.ofNullable(wireMockResponse.getHeaders()).orElse(new HttpHeaders()).all()) {
                if (!header.getKey().matches(this.config.getIncludeResponseHeadersRegexp())) continue;
                pactResponse.getHeaders().put(header.getKey(), header.getValues());
            }
            ((List)interactionsPerProvider.get(provider)).add(interaction);
        }
        for (Map.Entry entry : interactionsPerProvider.entrySet()) {
            V4Pact v4 = new V4Pact(consumer, new Provider((String)entry.getKey()));
            v4.getInteractions().addAll((Collection)entry.getValue());
            LOG.fine("Saving " + v4 + " to " + this.getAbsoluteJsonFolder());
            v4.write(this.getAbsoluteJsonFolder(), PactSpecVersion.V4);
        }
    }

    private List<String> getProviderStates(ServeEvent serveEvent, List<String> metadataProviderStates) {
        if (!metadataProviderStates.isEmpty()) {
            return metadataProviderStates;
        }
        if (serveEvent.getWasMatched() && serveEvent.getStubMapping().getScenarioName() != null && serveEvent.getStubMapping().getRequiredScenarioState() != null) {
            return List.of(serveEvent.getStubMapping().getScenarioName() + "---" + serveEvent.getStubMapping().getRequiredScenarioState());
        }
        return this.config.getProviderStatesDefaultValue();
    }

    private WireMockPactMetadata getMetadataModel(ServeEvent serveEvent) {
        Metadata metadata = serveEvent.getStubMapping().getMetadata();
        if (metadata == null) {
            return new WireMockPactMetadata();
        }
        String json = JsonHelper.toJson(metadata.get((Object)"wireMockPactSettings"));
        return JsonHelper.fromJson(WireMockPactMetadata.class, json);
    }

    private String getAbsoluteJsonFolder() {
        return Paths.get(this.config.getPactJsonFolder(), new String[0]).toFile().getAbsolutePath();
    }

    public List<File> getAllSaved() {
        String absoluteJsonFolder = this.getAbsoluteJsonFolder();
        LOG.info("Clearing PACT JSON in " + absoluteJsonFolder);
        Path path = Paths.get(absoluteJsonFolder, new String[0]);
        if (path == null || path.toFile() == null || path.toFile().listFiles() == null) {
            return new ArrayList<File>();
        }
        return Arrays.asList(path.toFile().listFiles()).stream().filter(it -> it.getName().endsWith(".json")).map(it -> it).toList();
    }

    public Map<String, String> getAllSavedContent() {
        return new TreeMap<String, String>(this.getAllSaved().stream().collect(Collectors.toMap(File::getName, it -> {
            try {
                return Files.readString(it.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })));
    }

    public void clearAllSaved() {
        String absoluteJsonFolder = this.getAbsoluteJsonFolder();
        LOG.info("Clearing PACT JSON in " + absoluteJsonFolder);
        Path path = Paths.get(absoluteJsonFolder, new String[0]);
        if (path == null || path.toFile() == null || path.toFile().listFiles() == null) {
            return;
        }
        this.getAllSaved().forEach(it -> {
            if (!it.delete()) {
                LOG.warning("Unable to delete " + it.getAbsolutePath());
            }
        });
    }
}

