/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.encoding;

import java.util.Base64;
import java.util.Optional;

public class Barcode {
    private final BarcodeType type;
    private final ImageFormat imageFormat;
    private final byte[] image;
    private final String svgImage;
    private final int width;
    private final int height;
    private final String payload;

    public Barcode(BarcodeType type, byte[] image, ImageFormat imageFormat, String svgImage, int width, int height, String payload) {
        this.type = Optional.ofNullable(type).orElseThrow(() -> new IllegalArgumentException("type must not be null"));
        this.image = Optional.ofNullable(image).filter(c -> ((byte[])c).length > 0).orElseThrow(() -> new IllegalArgumentException("code must not be null or empty"));
        this.imageFormat = Optional.ofNullable(imageFormat).orElseThrow(() -> new IllegalArgumentException("imageFormat must not be null"));
        this.svgImage = Optional.ofNullable(svgImage).orElseThrow(() -> new IllegalArgumentException("svgImage must not be null"));
        this.width = width;
        this.height = height;
        this.payload = Optional.ofNullable(payload).orElseThrow(() -> new IllegalArgumentException("payload must not be null"));
        if (this.width <= 0) {
            throw new IllegalArgumentException("width must be a positive integer");
        }
        if (this.height <= 0) {
            throw new IllegalArgumentException("height must be a positive integer");
        }
    }

    public BarcodeType getType() {
        return this.type;
    }

    public ImageFormat getImageFormat() {
        return this.imageFormat;
    }

    public byte[] getImage() {
        return this.image;
    }

    public String getSvgImage() {
        return this.svgImage;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getPayload() {
        return this.payload;
    }

    public String toBase64Image() {
        return String.format("data:image/%s;base64, %s", this.imageFormat.getName().toLowerCase(), Base64.getEncoder().encodeToString(this.image));
    }

    public String toString() {
        return String.format("%s barcode in %s format (%d x %d) - %s", new Object[]{this.type, this.imageFormat.getName(), this.width, this.height, Base64.getEncoder().encodeToString(this.image)});
    }

    public static enum ImageFormat {
        JPG("jpg", "image/jpg"),
        PNG("png", "image/png");

        private final String name;
        private final String mimeType;

        public String getName() {
            return this.name;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public static ImageFormat parse(String name) {
            for (ImageFormat i : ImageFormat.values()) {
                if (!i.getName().equalsIgnoreCase(name)) continue;
                return i;
            }
            throw new IllegalArgumentException("Unsupported image format - " + name);
        }

        public static ImageFormat parseFromMimeType(String mimeType) {
            for (ImageFormat i : ImageFormat.values()) {
                if (!i.getMimeType().equalsIgnoreCase(mimeType)) continue;
                return i;
            }
            throw new IllegalArgumentException("Unsupported image MIME type - " + mimeType);
        }

        private ImageFormat(String name, String mimeType) {
            this.name = name;
            this.mimeType = mimeType;
        }
    }

    public static enum BarcodeType {
        AZTEC("AZTEC"),
        QR("QR");

        private final String name;

        public String getName() {
            return this.name;
        }

        public static BarcodeType parse(String name) {
            for (BarcodeType t : BarcodeType.values()) {
                if (!t.getName().equalsIgnoreCase(name)) continue;
                return t;
            }
            throw new IllegalArgumentException("Unsupported Barcode type - " + name);
        }

        private BarcodeType(String name) {
            this.name = name;
        }
    }
}

