/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.encoding;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Base45 {
    public static final byte[] ALPHABET = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 32, 36, 37, 42, 43, 45, 46, 47, 58};

    private Base45() {
    }

    public static Encoder getEncoder() {
        return Encoder.ENCODER;
    }

    public static Decoder getDecoder() {
        return Decoder.DECODER;
    }

    public static class Decoder {
        public static final Decoder DECODER = new Decoder();
        private static final int[] DECODING_TABLE = new int[256];

        private Decoder() {
        }

        public byte[] decode(byte[] src) {
            int resultLength = src.length / 3 * 2 + src.length % 3 / 2;
            byte[] result = new byte[resultLength];
            int op = 0;
            for (int ip = 0; ip < src.length; ++ip) {
                int b2;
                byte i2;
                byte i0 = src[ip++];
                byte i1 = src[ip++];
                byte by = i2 = ip < src.length ? src[ip] : (byte)0;
                if (i0 > 127 || i1 > 127 || i2 > 127) {
                    throw new IllegalArgumentException("Illegal character in Base45 encoded data.");
                }
                int b0 = DECODING_TABLE[i0];
                int b1 = ip <= src.length ? DECODING_TABLE[i1] : 0;
                int n = b2 = ip < src.length ? DECODING_TABLE[i2] : 0;
                if (b0 < 0 || b1 < 0 || b2 < 0) {
                    throw new IllegalArgumentException("Illegal character in Base45 encoded data.");
                }
                int value = b0 + 45 * b1 + 2025 * b2;
                int o0 = value / 256;
                int o1 = value % 256;
                byte by2 = result[op++] = op < resultLength ? (byte)o0 : (byte)o1;
                if (op >= resultLength) continue;
                result[op++] = (byte)o1;
            }
            return result;
        }

        public byte[] decode(String src) {
            return this.decode(src.getBytes(StandardCharsets.US_ASCII));
        }

        static {
            Arrays.fill(DECODING_TABLE, -1);
            for (int i = 0; i < ALPHABET.length; ++i) {
                Decoder.DECODING_TABLE[Base45.ALPHABET[i]] = i;
            }
        }
    }

    public static class Encoder {
        public static final Encoder ENCODER = new Encoder();

        private Encoder() {
        }

        public byte[] encode(byte[] src) {
            int length = src.length / 2 * 3 + src.length % 2 * 2;
            byte[] result = new byte[length];
            int op = 0;
            for (int ip = 0; ip < src.length; ++ip) {
                int i0 = src[ip++] & 0xFF;
                int i1 = ip < src.length ? src[ip] & 0xFF : 0;
                int out = ip < src.length ? i0 * 256 + i1 : i0;
                int o0 = out % 45;
                int o1 = out / 45 % 45;
                int o2 = out / 45 / 45;
                result[op++] = ALPHABET[o0];
                byte by = result[op] = op < length ? ALPHABET[o1] : ALPHABET[o2];
                if (++op >= length) continue;
                result[op++] = ALPHABET[o2];
            }
            return result;
        }

        public String encodeToString(byte[] src) {
            return new String(this.encode(src), StandardCharsets.US_ASCII);
        }
    }
}

