/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.encoding.impl;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.aztec.AztecWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Optional;
import se.digg.dgc.encoding.Barcode;
import se.digg.dgc.encoding.BarcodeCreator;
import se.digg.dgc.encoding.BarcodeException;

public class DefaultBarcodeCreator
implements BarcodeCreator {
    public static final Barcode.BarcodeType DEFAULT_TYPE = Barcode.BarcodeType.QR;
    public static final Barcode.ImageFormat DEFAULT_IMAGE_FORMAT = Barcode.ImageFormat.PNG;
    public static final int DEFAULT_WIDTH_AND_HEIGHT = 300;
    private Barcode.BarcodeType type = DEFAULT_TYPE;
    private Barcode.ImageFormat imageFormat = DEFAULT_IMAGE_FORMAT;
    private int widthAndHeight = 300;

    @Override
    public Barcode create(String contents) throws BarcodeException {
        return this.create(contents, null);
    }

    @Override
    public Barcode create(String contents, Charset characterSet) throws BarcodeException {
        Barcode barcode;
        if (contents == null || contents.trim().isEmpty()) {
            throw new IllegalArgumentException("contents is not set");
        }
        QRCodeWriter writer = null;
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        if (characterSet != null) {
            hints.put(EncodeHintType.CHARACTER_SET, characterSet.name());
        }
        if (this.type == Barcode.BarcodeType.QR) {
            writer = new QRCodeWriter();
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.Q);
        } else {
            writer = new AztecWriter();
            hints.put(EncodeHintType.ERROR_CORRECTION, 23);
        }
        BitMatrix bitMatrix = writer.encode(contents, this.zxingBarcodeFormat(), this.widthAndHeight, this.widthAndHeight, hints);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)this.imageFormat.getName(), (OutputStream)stream);
            byte[] bytes = stream.toByteArray();
            barcode = new Barcode(this.type, bytes, this.imageFormat, this.toSvgImage(bitMatrix), this.widthAndHeight, this.widthAndHeight, contents);
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BarcodeException("Failed to create barcode - " + e.getMessage(), e);
                }
            }
            catch (WriterException e) {
                throw new BarcodeException("Failed to create barcode - " + e.getMessage(), e);
            }
        }
        stream.close();
        return barcode;
    }

    private String toSvgImage(BitMatrix image) {
        int width = image.getWidth();
        int height = image.getHeight();
        StringBuilder sb = new StringBuilder();
        sb.append("<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 ").append(width).append(" ").append(height).append("\">").append(System.lineSeparator());
        BitArray row = new BitArray(width);
        for (int y = 0; y < height; ++y) {
            StringBuilder sbPath = new StringBuilder();
            row = image.getRow(y, row);
            for (int x = 0; x < width; ++x) {
                if (!row.get(x)) continue;
                sbPath.append(" M" + x + "," + y + "h1v1h-1z");
            }
            if (sbPath.length() <= 0) continue;
            sb.append("<path d=\"").append(sbPath.toString()).append("\"></path>").append(System.lineSeparator());
        }
        sb.append("</svg>").append(System.lineSeparator());
        return sb.toString();
    }

    private BarcodeFormat zxingBarcodeFormat() {
        if (this.type == Barcode.BarcodeType.QR) {
            return BarcodeFormat.QR_CODE;
        }
        return BarcodeFormat.AZTEC;
    }

    public void setType(Barcode.BarcodeType type) {
        this.type = Optional.ofNullable(type).orElse(DEFAULT_TYPE);
    }

    public void setImageFormat(Barcode.ImageFormat imageFormat) {
        this.imageFormat = Optional.ofNullable(imageFormat).orElse(DEFAULT_IMAGE_FORMAT);
    }

    public void setWidthAndHeight(int widthAndHeight) {
        if (widthAndHeight <= 0) {
            throw new IllegalArgumentException("widthAndHeight must be greater than 0");
        }
        this.widthAndHeight = widthAndHeight;
    }
}

