/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.encoding.impl;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.aztec.AztecReader;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import se.digg.dgc.encoding.Barcode;
import se.digg.dgc.encoding.BarcodeDecoder;
import se.digg.dgc.encoding.BarcodeException;

public class DefaultBarcodeDecoder
implements BarcodeDecoder {
    private static Map<DecodeHintType, Object> HINTS = new HashMap<DecodeHintType, Object>();

    @Override
    public byte[] decode(byte[] image, Barcode.BarcodeType type) throws BarcodeException {
        Object reader;
        BufferedImage bufferedImage = null;
        try (ByteArrayInputStream imageStream = new ByteArrayInputStream(image);){
            bufferedImage = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new BarcodeException("Failed to read supplied image bytes into a valid image", e);
        }
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(bufferedImage)));
        HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
        hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        if (type == null) {
            reader = new MultiFormatReader();
            hints.put(DecodeHintType.POSSIBLE_FORMATS, Arrays.asList(BarcodeFormat.QR_CODE, BarcodeFormat.AZTEC));
        } else {
            reader = type == Barcode.BarcodeType.QR ? new QRCodeReader() : new AztecReader();
        }
        try {
            Result result = null;
            try {
                result = reader.decode(bitmap, hints);
            }
            catch (FormatException | NotFoundException e) {
                hints.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
                result = reader.decode(bitmap, hints);
            }
            if (result.getText() != null) {
                return result.getText().getBytes();
            }
            throw new BarcodeException("No contents found inside of supplied image");
        }
        catch (NotFoundException e) {
            throw new BarcodeException("No barcode found inside supplied image", e);
        }
        catch (ChecksumException e) {
            throw new BarcodeException("Barcode checksum error", e);
        }
        catch (FormatException e) {
            throw new BarcodeException("Barcode format error", e);
        }
    }

    @Override
    public String decodeToString(byte[] image, Barcode.BarcodeType type, Charset characterSet) throws BarcodeException {
        byte[] bytes = this.decode(image, type);
        return new String(bytes, characterSet != null ? characterSet : Charset.defaultCharset());
    }

    static {
        HINTS.put(DecodeHintType.POSSIBLE_FORMATS, Arrays.asList(BarcodeFormat.QR_CODE, BarcodeFormat.AZTEC));
    }
}

