/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.service.impl;

import java.io.IOException;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.digg.dgc.encoding.Barcode;
import se.digg.dgc.encoding.BarcodeDecoder;
import se.digg.dgc.encoding.BarcodeException;
import se.digg.dgc.payload.v1.DGCSchemaException;
import se.digg.dgc.payload.v1.DigitalCovidCertificate;
import se.digg.dgc.service.DGCBarcodeDecoder;
import se.digg.dgc.service.impl.DefaultDGCDecoder;
import se.digg.dgc.signatures.CertificateProvider;
import se.digg.dgc.signatures.DGCSignatureVerifier;

public class DefaultDGCBarcodeDecoder
extends DefaultDGCDecoder
implements DGCBarcodeDecoder {
    private static final Logger log = LoggerFactory.getLogger(DefaultDGCBarcodeDecoder.class);
    private BarcodeDecoder barcodeDecoder;

    public DefaultDGCBarcodeDecoder(DGCSignatureVerifier dgcSignatureVerifier, CertificateProvider certificateProvider, BarcodeDecoder barcodeDecoder) {
        super(dgcSignatureVerifier, certificateProvider);
        this.barcodeDecoder = barcodeDecoder;
    }

    @Override
    public DigitalCovidCertificate decodeBarcode(byte[] image) throws DGCSchemaException, SignatureException, CertificateExpiredException, BarcodeException, IOException {
        byte[] encodedDcc = this.decodeBarcodeToBytes(image);
        log.trace("CBOR decoding DGC ...");
        DigitalCovidCertificate dgc = DigitalCovidCertificate.decode((byte[])encodedDcc);
        log.trace("Decoded into: {}", (Object)dgc);
        return dgc;
    }

    @Override
    public byte[] decodeBarcodeToBytes(byte[] image) throws SignatureException, CertificateExpiredException, BarcodeException, IOException {
        log.trace("Decoding barcode image ...");
        String base45 = this.barcodeDecoder.decodeToString(image, Barcode.BarcodeType.QR, null);
        log.trace("Decoded barcode image into {}", (Object)base45);
        return this.decodeToBytes(base45);
    }
}

