/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.service.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.digg.dgc.encoding.Barcode;
import se.digg.dgc.encoding.BarcodeCreator;
import se.digg.dgc.encoding.BarcodeException;
import se.digg.dgc.payload.v1.DGCSchemaException;
import se.digg.dgc.payload.v1.DigitalCovidCertificate;
import se.digg.dgc.service.DGCBarcodeEncoder;
import se.digg.dgc.service.impl.DefaultDGCEncoder;
import se.digg.dgc.signatures.DGCSigner;

public class DefaultDGCBarcodeEncoder
extends DefaultDGCEncoder
implements DGCBarcodeEncoder {
    private static final Logger log = LoggerFactory.getLogger(DefaultDGCBarcodeEncoder.class);
    private final BarcodeCreator barcodeCreator;

    public DefaultDGCBarcodeEncoder(DGCSigner dgcSigner, BarcodeCreator barcodeCreator) {
        super(dgcSigner);
        this.barcodeCreator = Optional.ofNullable(barcodeCreator).orElseThrow(() -> new IllegalArgumentException("barcodeCreator must be set"));
    }

    @Override
    public Barcode encodeToBarcode(DigitalCovidCertificate dcc, Instant expiration) throws DGCSchemaException, IOException, SignatureException, BarcodeException {
        log.trace("Creating barcode from DCC payload: {}", (Object)dcc);
        String base45 = this.encode(dcc, expiration);
        log.trace("Creating barcode ...");
        Barcode barcode = this.barcodeCreator.create(base45, StandardCharsets.US_ASCII);
        log.trace("Successfully created: {}", (Object)barcode);
        return barcode;
    }

    @Override
    public Barcode encodeToBarcode(byte[] dcc, Instant expiration) throws IOException, SignatureException, BarcodeException {
        String base45 = this.encode(dcc, expiration);
        log.trace("Creating barcode ...");
        Barcode barcode = this.barcodeCreator.create(base45, StandardCharsets.US_ASCII);
        log.trace("Successfully created: {}", (Object)barcode);
        return barcode;
    }
}

