/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.service.impl;

import com.upokecenter.cbor.CBORException;
import java.io.IOException;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.digg.dgc.encoding.Base45;
import se.digg.dgc.encoding.Zlib;
import se.digg.dgc.payload.v1.DGCSchemaException;
import se.digg.dgc.payload.v1.DigitalCovidCertificate;
import se.digg.dgc.service.DGCDecoder;
import se.digg.dgc.signatures.CertificateProvider;
import se.digg.dgc.signatures.DGCSignatureVerifier;
import se.digg.dgc.signatures.impl.DefaultDGCSignatureVerifier;

public class DefaultDGCDecoder
implements DGCDecoder {
    private static final Logger log = LoggerFactory.getLogger(DefaultDGCDecoder.class);
    private final DGCSignatureVerifier dgcSignatureVerifier;
    private final CertificateProvider certificateProvider;

    public DefaultDGCDecoder(DGCSignatureVerifier dgcSignatureVerifier, CertificateProvider certificateProvider) {
        this.dgcSignatureVerifier = Optional.ofNullable(dgcSignatureVerifier).orElse(new DefaultDGCSignatureVerifier());
        this.certificateProvider = Optional.ofNullable(certificateProvider).orElseThrow(() -> new IllegalArgumentException("certificateProvider must be supplied"));
    }

    @Override
    public DigitalCovidCertificate decode(String base45) throws DGCSchemaException, SignatureException, CertificateExpiredException, IOException {
        byte[] dccEncoding = this.decodeToBytes(base45);
        log.trace("CBOR decoding DCC ...");
        DigitalCovidCertificate dcc = DigitalCovidCertificate.decode((byte[])dccEncoding);
        log.trace("Decoded into: {}", (Object)dcc);
        return dcc;
    }

    @Override
    public byte[] decodeToBytes(String base45) throws SignatureException, CertificateExpiredException, IOException {
        String input = base45;
        if (input.startsWith("HC1:")) {
            input = input.substring("HC1:".length());
            log.trace("Stripped {} header - Base45 encoding is {} characters long", (Object)"HC1:", (Object)input.length());
        } else {
            log.info("Missing header - {}", (Object)"HC1:");
        }
        log.trace("Base45 decoding into a compressed CWT ...");
        byte[] compressedCwt = Base45.getDecoder().decode(input);
        log.trace("Compressed CWT is {} bytes long", (Object)compressedCwt.length);
        log.trace("De-compressing the CWT ...");
        if (!Zlib.isCompressed(compressedCwt)) {
            log.info("The data to inflate is missing ZLIB header byte - assuming un-compressed data");
        }
        byte[] cwt = Zlib.decompress(compressedCwt, false);
        log.trace("Inflated data into CWT of length {}", (Object)cwt.length);
        return this.decodeRawToBytes(cwt);
    }

    @Override
    public DigitalCovidCertificate decodeRaw(byte[] cwt) throws DGCSchemaException, SignatureException, CertificateExpiredException, IOException {
        byte[] encodedDcc = this.decodeRawToBytes(cwt);
        log.trace("CBOR decoding DCC ...");
        DigitalCovidCertificate dcc = DigitalCovidCertificate.decode((byte[])encodedDcc);
        log.trace("Decoded into: {}", (Object)dcc);
        return dcc;
    }

    @Override
    public byte[] decodeRawToBytes(byte[] cwt) throws SignatureException, CertificateExpiredException, IOException {
        try {
            log.trace("Verifying signature on signed CWT ...");
            DGCSignatureVerifier.Result result = this.dgcSignatureVerifier.verify(cwt, this.certificateProvider);
            log.debug("Successful signature validation of signed CWT. dgc-length='{}', issuing-country='{}', issued-at='{}', expires='{}'", new Object[]{result.getDgcPayload().length, result.getCountry(), result.getIssuedAt(), result.getExpires()});
            log.trace("Subject DN of certificate used to verify signature: {}", (Object)result.getSignerCertificate().getSubjectX500Principal().toString());
            return result.getDgcPayload();
        }
        catch (CBORException e) {
            throw new IOException("CBOR error - " + e.getMessage(), e);
        }
    }
}

