/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.service.impl;

import com.upokecenter.cbor.CBORException;
import java.io.IOException;
import java.security.SignatureException;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.digg.dgc.encoding.Base45;
import se.digg.dgc.encoding.Zlib;
import se.digg.dgc.payload.v1.DGCSchemaException;
import se.digg.dgc.payload.v1.DigitalCovidCertificate;
import se.digg.dgc.service.DGCEncoder;
import se.digg.dgc.signatures.DGCSigner;

public class DefaultDGCEncoder
implements DGCEncoder {
    private static final Logger log = LoggerFactory.getLogger(DefaultDGCEncoder.class);
    private final DGCSigner dgcSigner;

    public DefaultDGCEncoder(DGCSigner dgcSigner) {
        this.dgcSigner = Optional.ofNullable(dgcSigner).orElseThrow(() -> new IllegalArgumentException("dgcSigner must not be null"));
    }

    @Override
    public String encode(DigitalCovidCertificate dcc, Instant expiration) throws DGCSchemaException, IOException, SignatureException {
        if (dcc.getVer() == null) {
            dcc.setVer("1.3.0");
        }
        log.trace("Encoding DCC payload to CBOR ...");
        byte[] cborDcc = dcc.encode();
        log.trace("Encoded DCC into {} bytes", (Object)cborDcc.length);
        return this.encode(cborDcc, expiration);
    }

    @Override
    public String encode(byte[] dcc, Instant expiration) throws IOException, SignatureException {
        log.trace("Encoding to Base45 from CBOR-encoded DCC-payload (length: {}) ...", (Object)dcc.length);
        byte[] cwt = this.sign(dcc, expiration);
        log.trace("Compressing the signed CWT of length {} ...", (Object)cwt.length);
        cwt = Zlib.compress(cwt);
        log.trace("Signed CWT was compressed into {} bytes", (Object)cwt.length);
        log.trace("Base45 encoding compressed CWT ...");
        String base45 = Base45.getEncoder().encodeToString(cwt);
        log.trace("Base45 encoding: {}", (Object)base45);
        return "HC1:" + base45;
    }

    @Override
    public byte[] sign(DigitalCovidCertificate dcc, Instant expiration) throws DGCSchemaException, IOException, SignatureException {
        log.trace("Signing DCC: {}", (Object)dcc);
        log.trace("CBOR encoding DCC ...");
        byte[] cborDcc = dcc.encode();
        log.trace("Encoded DCC into {} bytes", (Object)cborDcc.length);
        return this.sign(cborDcc, expiration);
    }

    @Override
    public byte[] sign(byte[] dcc, Instant expiration) throws IOException, SignatureException {
        try {
            log.trace("Creating CWT and signing CBOR-encoded DCC (length: {}) ...", (Object)dcc.length);
            return this.dgcSigner.sign(dcc, expiration);
        }
        catch (CBORException e) {
            log.info("Internal CBOR error - {}", (Object)e.getMessage(), (Object)e);
            throw new IOException("Internal CBOR error - " + e.getMessage(), e);
        }
    }
}

