/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.signatures;

import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import se.digg.dgc.signatures.CertificateProvider;

public interface DGCSignatureVerifier {
    public Result verify(byte[] var1, CertificateProvider var2) throws SignatureException, CertificateExpiredException;

    public static class Result {
        private final byte[] dgcPayload;
        private final X509Certificate signerCertificate;
        private final byte[] kid;
        private final String country;
        private final Instant issuedAt;
        private final Instant expires;

        public Result(byte[] dccPayload, X509Certificate signerCertificate, byte[] kid, String country, Instant issuedAt, Instant expires) {
            this.dgcPayload = dccPayload;
            this.signerCertificate = signerCertificate;
            this.kid = kid;
            this.country = country;
            this.issuedAt = issuedAt;
            this.expires = expires;
        }

        public byte[] getDgcPayload() {
            return this.dgcPayload;
        }

        public X509Certificate getSignerCertificate() {
            return this.signerCertificate;
        }

        public byte[] getKid() {
            return this.kid;
        }

        public String getCountry() {
            return this.country;
        }

        public Instant getIssuedAt() {
            return this.issuedAt;
        }

        public Instant getExpires() {
            return this.expires;
        }
    }
}

