/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.signatures.cose;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.crypto.impl.ECDSA;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Optional;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import se.digg.dgc.signatures.cose.HeaderParameterKey;
import se.digg.dgc.signatures.cose.SignatureAlgorithm;
import se.digg.dgc.signatures.cwt.Cwt;

public class CoseSign1_Object {
    public static final int MESSAGE_TAG = 18;
    private boolean includeMessageTag = true;
    private CBORObject protectedAttributes;
    private byte[] protectedAttributesEncoding;
    private CBORObject unprotectedAttributes;
    private byte[] content;
    private byte[] signature;
    private static final byte[] externalData = new byte[0];
    private static final String contextString = "Signature1";

    public CoseSign1_Object() {
        this.protectedAttributes = CBORObject.NewMap();
        this.unprotectedAttributes = CBORObject.NewMap();
    }

    public CoseSign1_Object(byte[] data) throws CBORException {
        CBORObject message = CBORObject.DecodeFromBytes((byte[])data);
        if (message.getType() != CBORType.Array) {
            throw new CBORException("Supplied message is not a valid COSE security object");
        }
        if (message.isTagged()) {
            if (message.GetAllTags().length > 2) {
                throw new CBORException("Invalid object - too many tags");
            }
            if (message.GetAllTags().length == 2 && 61 != message.getMostOuterTag().ToInt32Unchecked()) {
                throw new CBORException(String.format("Invalid COSE_Sign1 structure - Expected CWT %d tag - but was %d", 61, message.getMostInnerTag().ToInt32Unchecked()));
            }
            if (18 != message.getMostInnerTag().ToInt32Unchecked()) {
                throw new CBORException(String.format("Invalid COSE_Sign1 structure - Expected %d tag - but was %d", 18, message.getMostInnerTag().ToInt32Unchecked()));
            }
        }
        if (message.size() != 4) {
            throw new CBORException(String.format("Invalid COSE_Sign1 structure - Expected an array of 4 items - but array has %d items", message.size()));
        }
        if (message.get(0).getType() == CBORType.ByteString) {
            this.protectedAttributesEncoding = message.get(0).GetByteString();
            if (message.get(0).GetByteString().length == 0) {
                this.protectedAttributes = CBORObject.NewMap();
            } else {
                this.protectedAttributes = CBORObject.DecodeFromBytes((byte[])this.protectedAttributesEncoding);
                if (this.protectedAttributes.size() == 0) {
                    this.protectedAttributesEncoding = new byte[0];
                }
            }
        } else {
            throw new CBORException(String.format("Invalid COSE_Sign1 structure - Expected item at position 1/4 to be a bstr which is the encoding of the protected attributes, but was %s", message.get(0).getType()));
        }
        if (message.get(1).getType() != CBORType.Map) {
            throw new CBORException(String.format("Invalid COSE_Sign1 structure - Expected item at position 2/4 to be a Map for unprotected attributes, but was %s", message.get(1).getType()));
        }
        this.unprotectedAttributes = message.get(1);
        if (message.get(2).getType() == CBORType.ByteString) {
            this.content = message.get(2).GetByteString();
        } else if (!message.get(2).isNull()) {
            throw new CBORException(String.format("Invalid COSE_Sign1 structure - Expected item at position 3/4 to be a bstr holding the payload, but was %s", message.get(2).getType()));
        }
        if (message.get(3).getType() != CBORType.ByteString) {
            throw new CBORException(String.format("Invalid COSE_Sign1 structure - Expected item at position 4/4 to be a bstr holding the signature, but was %s", message.get(2).getType()));
        }
        this.signature = message.get(3).GetByteString();
    }

    public static CoseSign1_ObjectBuilder builder() {
        return new CoseSign1_ObjectBuilder();
    }

    public static CoseSign1_Object decode(byte[] data) throws CBORException {
        return new CoseSign1_Object(data);
    }

    public byte[] encode() throws CBORException {
        if (this.signature == null || this.protectedAttributesEncoding == null) {
            throw new CBORException("Cannot encode COSE_Sign1 message - missing signature");
        }
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)this.protectedAttributesEncoding);
        obj.Add(this.unprotectedAttributes);
        obj.Add((Object)this.content);
        obj.Add((Object)this.signature);
        if (this.includeMessageTag) {
            obj = CBORObject.FromObjectAndTag((Object)obj, (int)18);
        }
        return obj.EncodeToBytes();
    }

    public void sign(PrivateKey signingKey, Provider provider) throws SignatureException, CBORException {
        if (this.signature != null) {
            throw new SignatureException("Object has already been signed");
        }
        if (this.content == null) {
            throw new SignatureException("No content specified");
        }
        if (this.protectedAttributesEncoding == null) {
            this.protectedAttributesEncoding = this.protectedAttributes.size() > 0 ? this.protectedAttributes.EncodeToBytes() : new byte[0];
        }
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)contextString);
        obj.Add((Object)this.protectedAttributesEncoding);
        obj.Add((Object)externalData);
        obj.Add((Object)this.content);
        byte[] tbsData = obj.EncodeToBytes();
        CBORObject registeredAlgorithm = this.protectedAttributes.get(HeaderParameterKey.ALG.getCborObject());
        if (registeredAlgorithm == null) {
            throw new SignatureException("No algorithm ID stored in protected attributes - cannot sign");
        }
        SignatureAlgorithm algorithm = SignatureAlgorithm.fromCborObject(registeredAlgorithm);
        try {
            Signature signature = provider != null ? Signature.getInstance(algorithm.getJcaAlgorithmName(), provider) : Signature.getInstance(algorithm.getJcaAlgorithmName());
            signature.initSign(signingKey);
            signature.update(tbsData);
            byte[] result = signature.sign();
            this.signature = algorithm == SignatureAlgorithm.ES256 ? ECDSA.transcodeSignatureToConcat((byte[])result, (int)64) : (algorithm == SignatureAlgorithm.ES384 ? ECDSA.transcodeSignatureToConcat((byte[])result, (int)96) : (algorithm == SignatureAlgorithm.ES512 ? ECDSA.transcodeSignatureToConcat((byte[])result, (int)132) : result));
        }
        catch (JOSEException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SignatureException("Failed to sign - " + e.getMessage(), e);
        }
    }

    public byte[] getKeyIdentifier() {
        CBORObject kid = Optional.ofNullable(this.protectedAttributes.get(HeaderParameterKey.KID.getCborObject())).orElse(this.unprotectedAttributes.get(HeaderParameterKey.KID.getCborObject()));
        if (kid == null) {
            return null;
        }
        return kid.GetByteString();
    }

    public Cwt getCwt() throws CBORException {
        if (this.content == null) {
            return null;
        }
        return Cwt.decode(this.content);
    }

    public void verifySignature(PublicKey publicKey) throws SignatureException {
        if (this.signature == null) {
            throw new SignatureException("Object is not signed");
        }
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)contextString);
        obj.Add((Object)this.protectedAttributesEncoding);
        obj.Add((Object)externalData);
        if (this.content != null) {
            obj.Add((Object)this.content);
        } else {
            obj.Add(null);
        }
        byte[] signedData = obj.EncodeToBytes();
        CBORObject registeredAlgorithm = this.protectedAttributes.get(HeaderParameterKey.ALG.getCborObject());
        if (registeredAlgorithm == null) {
            throw new SignatureException("No algorithm ID stored in protected attributes - cannot sign");
        }
        SignatureAlgorithm algorithm = SignatureAlgorithm.fromCborObject(registeredAlgorithm);
        byte[] signatureToVerify = this.signature;
        try {
            if (algorithm == SignatureAlgorithm.ES256 || algorithm == SignatureAlgorithm.ES384 || algorithm == SignatureAlgorithm.ES512) {
                signatureToVerify = ECDSA.transcodeSignatureToDER((byte[])this.signature);
            }
            Signature verifier = Signature.getInstance(algorithm.getJcaAlgorithmName());
            verifier.initVerify(publicKey);
            verifier.update(signedData);
            if (!verifier.verify(signatureToVerify)) {
                throw new SignatureException("Signature did not verify correctly");
            }
        }
        catch (JOSEException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SignatureException("Failed to verify signature - " + e.getMessage(), e);
        }
    }

    public void addProtectedAttribute(CBORObject label, CBORObject value) throws CBORException {
        if (this.signature != null) {
            throw new CBORException("Cannot add protected attribute to already signed COSE_Sign1 object");
        }
        this.removeProtectedAttribute(label);
        this.protectedAttributes.Add((Object)label, (Object)value);
    }

    public void removeProtectedAttribute(CBORObject label) throws CBORException {
        if (this.protectedAttributes.ContainsKey(label)) {
            if (this.signature != null) {
                throw new CBORException("Cannot remove protected attribute from signed COSE_Sign1 object");
            }
            this.protectedAttributes.Remove(label);
        }
    }

    public void addUnprotectedAttribute(CBORObject label, CBORObject value) {
        this.removeUnprotectedAttribute(label);
        this.unprotectedAttributes.Add((Object)label, (Object)value);
    }

    public void removeUnprotectedAttribute(CBORObject label) {
        if (this.unprotectedAttributes.ContainsKey(label)) {
            this.unprotectedAttributes.Remove(label);
        }
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setIncludeMessageTag(boolean includeMessageTag) {
        this.includeMessageTag = includeMessageTag;
    }

    private static void ensureBouncyCastlePresent() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    static {
        CoseSign1_Object.ensureBouncyCastlePresent();
    }

    public static class CoseSign1_ObjectBuilder {
        private final CoseSign1_Object object = new CoseSign1_Object();

        public CoseSign1_Object build() {
            return this.object;
        }

        public CoseSign1_ObjectBuilder protectedAttribute(CBORObject label, CBORObject value) {
            this.object.addProtectedAttribute(label, value);
            return this;
        }

        public CoseSign1_ObjectBuilder unprotectedAttribute(CBORObject label, CBORObject value) {
            this.object.addUnprotectedAttribute(label, value);
            return this;
        }

        public CoseSign1_ObjectBuilder content(byte[] content) {
            this.object.setContent(content);
            return this;
        }

        public CoseSign1_ObjectBuilder includeMessageTag(boolean include) {
            this.object.setIncludeMessageTag(include);
            return this;
        }
    }
}

