/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.signatures.cose;

import com.upokecenter.cbor.CBORObject;

public enum SignatureAlgorithm {
    ES256(-7, "ES256", "SHA256withECDSA"),
    ES384(-35, "ES384", "SHA384withECDSA"),
    ES512(-36, "ES512", "SHA512withECDSA"),
    PS256(-37, "PS256", "SHA256withRSA/PSS"),
    PS384(-38, "PS384", "SHA384withRSA/PSS"),
    PS512(-39, "PS512", "SHA512withRSA/PSS");

    private final CBORObject value;
    private final String name;
    private final String jcaAlgorithmName;

    private SignatureAlgorithm(int value, String name, String jcaAlgorithmName) {
        this.value = CBORObject.FromObject((int)value);
        this.name = name;
        this.jcaAlgorithmName = jcaAlgorithmName;
    }

    public static SignatureAlgorithm fromCborObject(CBORObject value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        for (SignatureAlgorithm a : SignatureAlgorithm.values()) {
            if (!value.equals(a.value)) continue;
            return a;
        }
        throw new IllegalArgumentException("No SignatureAlgorithmID matching " + value);
    }

    public static SignatureAlgorithm fromValue(int value) {
        for (SignatureAlgorithm a : SignatureAlgorithm.values()) {
            if (a.value.AsInt32Value() != value) continue;
            return a;
        }
        throw new IllegalArgumentException("No SignatureAlgorithmId matching " + value);
    }

    public CBORObject getCborObject() {
        return this.value;
    }

    public int getValue() {
        return this.value.AsInt32Value();
    }

    public String getJcaAlgorithmName() {
        return this.jcaAlgorithmName;
    }

    public String getName() {
        return this.name;
    }
}

