/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.signatures.cwt;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import se.digg.dgc.signatures.cwt.support.CBORInstantConverter;

public class Cwt {
    public static final int HCERT_CLAIM_KEY = -260;
    public static final int EU_DGC_V1_MESSAGE_TAG = 1;
    public static final int MESSAGE_TAG = 61;
    private static final CBORInstantConverter instantConverter = new CBORInstantConverter();
    private final CBORObject cwtObject;

    public Cwt() {
        this.cwtObject = CBORObject.NewMap();
    }

    public Cwt(byte[] data) throws CBORException {
        CBORObject object = CBORObject.DecodeFromBytes((byte[])data);
        if (object.getType() != CBORType.Map) {
            throw new CBORException("Not a valid CWT");
        }
        this.cwtObject = object;
    }

    public static CwtBuilder builder() {
        return new CwtBuilder();
    }

    public static Cwt decode(byte[] data) throws CBORException {
        return new Cwt(data);
    }

    public byte[] encode() {
        return this.cwtObject.EncodeToBytes();
    }

    public void setIssuer(String issuer) {
        this.cwtObject.set(1, CBORObject.FromObject((String)issuer));
    }

    public String getIssuer() {
        return Optional.ofNullable(this.cwtObject.get(1)).map(CBORObject::AsString).orElse(null);
    }

    public void setSubject(String subject) {
        this.cwtObject.set(2, CBORObject.FromObject((String)subject));
    }

    public String getSubject() {
        return Optional.ofNullable(this.cwtObject.get(2)).map(CBORObject::AsString).orElse(null);
    }

    public void setAudience(String audience) {
        this.cwtObject.set(3, CBORObject.FromObject((String)audience));
    }

    public void setAudience(List<String> audiences) {
        if (audiences != null && audiences.size() == 1) {
            this.setAudience(audiences.get(0));
        } else if (audiences != null && !audiences.isEmpty()) {
            CBORObject arr = CBORObject.NewArray();
            for (String a : audiences) {
                arr.Add(CBORObject.FromObject((String)a));
            }
            this.cwtObject.set(3, arr);
        }
    }

    public List<String> getAudience() {
        CBORObject aud = this.cwtObject.get(3);
        if (aud == null) {
            return null;
        }
        if (aud.getType() == CBORType.Array) {
            Collection values = aud.getValues();
            return values.stream().map(CBORObject::AsString).collect(Collectors.toList());
        }
        return Arrays.asList(aud.AsString());
    }

    public void setExpiration(Instant exp) {
        this.cwtObject.set(4, instantConverter.ToCBORObject(exp));
    }

    public Instant getExpiration() {
        return instantConverter.FromCBORObject(this.cwtObject.get(4));
    }

    public void setNotBefore(Instant nbf) {
        this.cwtObject.set(5, instantConverter.ToCBORObject(nbf));
    }

    public Instant getNotBefore() {
        return instantConverter.FromCBORObject(this.cwtObject.get(5));
    }

    public void setIssuedAt(Instant iat) {
        this.cwtObject.set(6, instantConverter.ToCBORObject(iat));
    }

    public Instant getIssuedAt() {
        return instantConverter.FromCBORObject(this.cwtObject.get(6));
    }

    public void setCwtId(byte[] cti) {
        this.cwtObject.set(7, CBORObject.FromObject((byte[])cti));
    }

    public byte[] getCwtId() {
        return Optional.ofNullable(this.cwtObject.get(7)).map(CBORObject::GetByteString).orElse(null);
    }

    public void setDgcV1(byte[] dgcPayload) {
        CBORObject m = CBORObject.NewMap();
        m.set(1, CBORObject.DecodeFromBytes((byte[])dgcPayload));
        this.cwtObject.set(-260, m);
    }

    public byte[] getDgcV1() {
        CBORObject hcert = this.cwtObject.get(-260);
        return Optional.ofNullable(hcert.get(1)).map(CBORObject::EncodeToBytes).orElse(null);
    }

    public void setClaim(int claimKey, byte[] value) {
        this.cwtObject.set(claimKey, CBORObject.DecodeFromBytes((byte[])value));
    }

    public void setClaim(int claimKey, CBORObject value) {
        this.cwtObject.set(claimKey, value);
    }

    public void setClaim(String claimKey, byte[] value) {
        this.cwtObject.set(claimKey, CBORObject.DecodeFromBytes((byte[])value));
    }

    public void setClaim(String claimKey, CBORObject value) {
        this.cwtObject.set(claimKey, value);
    }

    public CBORObject getClaim(int claimKey) {
        return this.cwtObject.get(claimKey);
    }

    public CBORObject getClaim(String claimKey) {
        return this.cwtObject.get(claimKey);
    }

    public String toString() {
        return this.cwtObject.toString();
    }

    public static class CwtBuilder {
        private final Cwt cwt = new Cwt();

        public Cwt build() {
            return this.cwt;
        }

        public CwtBuilder issuer(String issuer) {
            this.cwt.setIssuer(issuer);
            return this;
        }

        public CwtBuilder subject(String subject) {
            this.cwt.setSubject(subject);
            return this;
        }

        public CwtBuilder audience(String audience) {
            List<String> contents = this.cwt.getAudience();
            if (contents == null) {
                this.cwt.setAudience(audience);
            } else {
                ArrayList<String> audiences = new ArrayList<String>(contents);
                audiences.add(audience);
                this.cwt.setAudience(audiences);
            }
            return this;
        }

        public CwtBuilder expiration(Instant exp) {
            this.cwt.setExpiration(exp);
            return this;
        }

        public CwtBuilder notBefore(Instant nbf) {
            this.cwt.setNotBefore(nbf);
            return this;
        }

        public CwtBuilder issuedAt(Instant iat) {
            this.cwt.setIssuedAt(iat);
            return this;
        }

        public CwtBuilder cwtId(byte[] cti) {
            this.cwt.setCwtId(cti);
            return this;
        }

        public CwtBuilder dgcV1(byte[] dgcPayload) {
            this.cwt.setDgcV1(dgcPayload);
            return this;
        }

        public CwtBuilder claim(int claimKey, byte[] value) {
            this.cwt.setClaim(claimKey, value);
            return this;
        }

        public CwtBuilder claim(int claimKey, CBORObject value) {
            this.cwt.setClaim(claimKey, value);
            return this;
        }

        public CwtBuilder claim(String claimKey, byte[] value) {
            this.cwt.setClaim(claimKey, value);
            return this;
        }

        public CwtBuilder claim(String claimKey, CBORObject value) {
            this.cwt.setClaim(claimKey, value);
            return this;
        }
    }
}

