/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.signatures.cwt.support;

import com.upokecenter.cbor.CBORDateConverter;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.ICBORToFromConverter;
import java.time.Instant;
import java.util.Date;

public class CBORInstantConverter
implements ICBORToFromConverter<Instant> {
    private static final CBORDateConverter untaggedDateConverter = CBORDateConverter.UntaggedNumber;
    private static final CBORDateConverter taggedDateConverter = CBORDateConverter.TaggedNumber;

    public CBORObject ToCBORObject(Instant obj) {
        if (obj == null) {
            return null;
        }
        return untaggedDateConverter.ToCBORObject(new Date(obj.getEpochSecond() * 1000L));
    }

    public Instant FromCBORObject(CBORObject obj) {
        if (obj == null) {
            return null;
        }
        Date date = obj.HasMostOuterTag(0) || obj.HasMostOuterTag(1) ? taggedDateConverter.FromCBORObject(obj) : untaggedDateConverter.FromCBORObject(obj);
        return Instant.ofEpochMilli(date.getTime());
    }
}

