/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.signatures.impl;

import com.upokecenter.cbor.CBORException;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.digg.dgc.signatures.CertificateProvider;
import se.digg.dgc.signatures.DGCSignatureVerifier;
import se.digg.dgc.signatures.cose.CoseSign1_Object;
import se.digg.dgc.signatures.cwt.Cwt;

public class DefaultDGCSignatureVerifier
implements DGCSignatureVerifier {
    private static final Logger log = LoggerFactory.getLogger(DefaultDGCSignatureVerifier.class);
    private Instant testValidationTime;

    @Override
    public DGCSignatureVerifier.Result verify(byte[] signedCwt, CertificateProvider certificateProvider) throws SignatureException, CertificateExpiredException {
        if (certificateProvider == null) {
            throw new IllegalArgumentException("certificateProvider must be supplied");
        }
        try {
            CoseSign1_Object coseObject = CoseSign1_Object.decode(signedCwt);
            byte[] kid = coseObject.getKeyIdentifier();
            String country = coseObject.getCwt().getIssuer();
            if (kid == null && country == null) {
                throw new SignatureException("Signed object does not contain key identifier or country - cannot find certificate");
            }
            List<X509Certificate> certs = certificateProvider.getCertificates(country, kid);
            for (X509Certificate cert : certs) {
                log.trace("Attempting DCC signature verification using certificate '{}'", (Object)cert.getSubjectX500Principal().getName());
                try {
                    byte[] dgcPayload;
                    coseObject.verifySignature(cert.getPublicKey());
                    log.debug("DCC signature verification succeeded using certificate '{}'", (Object)cert.getSubjectX500Principal().getName());
                    Cwt cwt = coseObject.getCwt();
                    Instant expiration = cwt.getExpiration();
                    if (expiration != null) {
                        if (this.getNow().isAfter(expiration)) {
                            throw new CertificateExpiredException("Signed DCC has expired");
                        }
                    } else {
                        log.warn("Signed HCERT did not contain an expiration time - assuming it is valid");
                    }
                    if ((dgcPayload = cwt.getDgcV1()) == null) {
                        throw new SignatureException("No DCC payload available in CWT");
                    }
                    return new DGCSignatureVerifier.Result(dgcPayload, cert, kid, country, cwt.getIssuedAt(), cwt.getExpiration());
                }
                catch (CBORException | SignatureException e) {
                    log.info("DGC signature verification failed using certificate '{}' - {}", new Object[]{cert.getSubjectX500Principal().getName(), e.getMessage(), e});
                }
            }
            if (certs.isEmpty()) {
                throw new SignatureException("No signer certificates could be found");
            }
            throw new SignatureException("Signature verification failed for all attempted certificates");
        }
        catch (CBORException e) {
            throw new SignatureException("Invalid signature - " + e.getMessage(), e);
        }
    }

    private Instant getNow() {
        if (this.testValidationTime != null) {
            log.warn("{} is in test mode - using simulated time for now: {}", (Object)this.getClass().getSimpleName(), (Object)this.testValidationTime);
            return this.testValidationTime;
        }
        return Instant.now();
    }

    public void setTestValidationTime(Instant testValidationTime) {
        this.testValidationTime = testValidationTime;
    }
}

