/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.uvci;

import se.digg.dgc.uvci.UVCIChecksumCalculator;

public class UVCIBuilder {
    public static final String UVCI_PREFIX = "URN:UVCI";
    public static final String UVCI_VERSION = "01";
    private static final String VERSION_REGEXP = "^[0-9][0-9]$";
    private static final String COUNTRY_REGEXP = "[A-Z]{2,3}";
    private static final String CONTENTS_REGEXP = "^[0-9A-Z]+$";
    private String prefix = "URN:UVCI";
    private String version;
    private String country;
    private String issuer;
    private String vaccine;
    private String uniqueString;
    private boolean includeChecksum = false;

    public static UVCIBuilder builder() {
        return new UVCIBuilder();
    }

    public String build() {
        if (this.country == null) {
            throw new IllegalArgumentException("Country has not been assigned");
        }
        if (this.uniqueString == null) {
            throw new IllegalArgumentException("Opaque unique string has not been assigned");
        }
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append(UVCI_PREFIX).append(':');
        }
        sb.append(this.version != null ? this.version : UVCI_VERSION).append(':');
        sb.append(this.country).append(':');
        if (this.issuer != null) {
            sb.append(this.issuer).append('/');
        }
        if (this.vaccine != null) {
            if (this.issuer == null) {
                throw new IllegalArgumentException("Invalid UVCI - If vaccine info is assigned, the issuing entity is also required");
            }
            sb.append(this.vaccine).append('/');
        }
        sb.append(this.uniqueString);
        if (this.includeChecksum) {
            return UVCIChecksumCalculator.addChecksum(sb.toString());
        }
        return sb.toString();
    }

    public UVCIBuilder prefix() {
        this.prefix = UVCI_PREFIX;
        return this;
    }

    public UVCIBuilder noPrefix() {
        this.prefix = null;
        return this;
    }

    public UVCIBuilder version(String version) {
        if (version != null) {
            if (!version.matches(VERSION_REGEXP)) {
                throw new IllegalArgumentException("Not a valid version string");
            }
            this.version = version;
        }
        return this;
    }

    public UVCIBuilder country(String country) {
        if (country != null && !country.matches(COUNTRY_REGEXP)) {
            throw new IllegalArgumentException("Not a valid country code (ISO 3166-1)");
        }
        this.country = country;
        return this;
    }

    public UVCIBuilder issuer(String issuer) {
        if (issuer != null && !issuer.matches(CONTENTS_REGEXP)) {
            throw new IllegalArgumentException("Issuer contains invalid characters");
        }
        this.issuer = issuer;
        return this;
    }

    public UVCIBuilder vaccine(String vaccine) {
        if (vaccine != null && !vaccine.matches(CONTENTS_REGEXP)) {
            throw new IllegalArgumentException("Vaccine string contains invalid characters");
        }
        this.vaccine = vaccine;
        return this;
    }

    public UVCIBuilder uniqueString(String uniqueString) {
        if (uniqueString != null && !uniqueString.matches(CONTENTS_REGEXP)) {
            throw new IllegalArgumentException("Opaque unique string contains invalid characters");
        }
        this.uniqueString = uniqueString;
        return this;
    }

    public UVCIBuilder includeChecksum(boolean include) {
        this.includeChecksum = include;
        return this;
    }
}

