/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.uvci;

public class UVCIChecksumCalculator {
    public static final String LUHN_MOD_N_CHARSET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/:";
    private static final String VALID_REGEXP = "^[ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/:]+$";
    public static final char DELIMITER = '#';

    public static char calculateChecksum(String input) {
        if (!input.matches(VALID_REGEXP)) {
            throw new IllegalArgumentException("Supplied input contains illegal characters");
        }
        int factor = 2;
        int sum = 0;
        int n = LUHN_MOD_N_CHARSET.length();
        for (int i = input.length() - 1; i >= 0; --i) {
            int codePoint = LUHN_MOD_N_CHARSET.indexOf(input.charAt(i));
            int addend = factor * codePoint;
            factor = factor == 2 ? 1 : 2;
            addend = addend / n + addend % n;
            sum += addend;
        }
        int remainder = sum % n;
        int checkCodePoint = (n - remainder) % n;
        return LUHN_MOD_N_CHARSET.charAt(checkCodePoint);
    }

    public static String addChecksum(String input) {
        char checksum = UVCIChecksumCalculator.calculateChecksum(input);
        return input + "#" + checksum;
    }

    public static boolean validateChecksum(String data) {
        try {
            if (data.length() > 2 && data.charAt(data.length() - 2) == '#') {
                char checksum;
                char expected = data.charAt(data.length() - 1);
                return expected == (checksum = UVCIChecksumCalculator.calculateChecksum(data.substring(0, data.length() - 2)));
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private UVCIChecksumCalculator() {
    }
}

