/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.payload.v1;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.format.DateTimeParseException;
import java.util.Optional;

public class DateOfBirth {
    private LocalDate dob;
    private Year year;
    private Month month;

    public DateOfBirth(String dob) throws DateTimeException {
        block8: {
            if (dob.trim().isEmpty()) {
                return;
            }
            try {
                this.dob = LocalDate.parse(dob);
            }
            catch (DateTimeParseException e) {
                String[] parts = dob.split("-");
                if (parts.length > 3) {
                    throw new DateTimeException("Invalid date of birth - " + dob);
                }
                this.year = Year.parse(parts[0].trim());
                if (parts.length <= 1) break block8;
                if ("XX".equalsIgnoreCase(parts[1].trim())) {
                    this.month = null;
                } else {
                    try {
                        this.month = Month.of(Integer.parseInt(parts[1]));
                    }
                    catch (NumberFormatException n) {
                        throw new DateTimeException("Invalid month", n);
                    }
                }
                if (parts.length != 3 || "XX".equalsIgnoreCase(parts[2].trim())) break block8;
                throw new DateTimeException("Invalid date of birth - " + dob);
            }
        }
    }

    public DateOfBirth(LocalDate dob) {
        this.dob = Optional.ofNullable(dob).orElseThrow(() -> new IllegalArgumentException("dob must not be null"));
    }

    public boolean isCompleteDate() {
        return this.dob != null;
    }

    public LocalDate asLocalDate() {
        return this.dob;
    }

    public Year getYear() {
        return this.dob != null ? Year.from(this.dob) : this.year;
    }

    public Month getMonth() {
        return this.dob != null ? Month.from(this.dob) : this.month;
    }

    public Integer getDayOfMonth() {
        return this.dob != null ? Integer.valueOf(this.dob.getDayOfMonth()) : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dob == null ? 0 : this.dob.hashCode());
        result = 31 * result + (this.month == null ? 0 : this.month.hashCode());
        result = 31 * result + (this.year == null ? 0 : this.year.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        if (this.dob != null) {
            return this.dob.toString();
        }
        if (this.year != null && this.month != null) {
            return String.format("%04d-%02d", this.year.getValue(), this.month.getValue());
        }
        if (this.year != null) {
            return String.format("%04d", this.year.getValue());
        }
        return "unknown";
    }
}

