/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.payload.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.InstantSerializer;
import com.upokecenter.cbor.CBORObject;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.function.BiFunction;
import java.util.function.Function;
import se.digg.dgc.payload.v1.DGCSchemaException;
import se.digg.dgc.payload.v1.DateOfBirth;
import se.digg.dgc.payload.v1.Eudcc;
import se.digg.dgc.payload.v1.PersonName;
import se.digg.dgc.transliteration.MrzEncoder;

public class DigitalCovidCertificate
extends Eudcc {
    private static CBORMapper cborMapper = new CBORMapper();
    private static ObjectMapper jsonMapper = new ObjectMapper();
    private boolean tagDateTimes = true;

    public DigitalCovidCertificate() {
        this.setVer("1.3.0");
    }

    public DigitalCovidCertificate(PersonName name, LocalDate dateOfBirth) {
        this();
        this.setVer("1.3.0");
        this.setNam(name);
        this.setDob(dateOfBirth);
    }

    @Override
    public void setNam(PersonName name) {
        super.setNam(DigitalCovidCertificate.transliterate(name));
    }

    @Override
    public Eudcc withNam(PersonName name) {
        return super.withNam(DigitalCovidCertificate.transliterate(name));
    }

    @JsonIgnore
    public DateOfBirth getDateOfBirth() throws DateTimeException {
        String dob = this.getDob();
        return dob != null ? new DateOfBirth(dob) : null;
    }

    @JsonIgnore
    public void setDob(LocalDate dob) {
        super.setDob(dob != null ? dob.toString() : null);
    }

    @JsonIgnore
    public void setDob(DateOfBirth dob) {
        super.setDob(dob != null ? dob.toString() : null);
    }

    public Eudcc withDob(LocalDate dob) {
        return super.withDob(dob != null ? dob.toString() : null);
    }

    public Eudcc withDob(DateOfBirth dob) {
        return super.withDob(dob != null ? dob.toString() : null);
    }

    private static PersonName transliterate(PersonName name) {
        if (name != null) {
            if (name.getFnt() == null && name.getFn() != null) {
                name.setFnt(MrzEncoder.encode(name.getFn()));
            }
            if (name.getGnt() == null && name.getGn() != null) {
                name.setGnt(MrzEncoder.encode(name.getGn()));
            }
        }
        return name;
    }

    public byte[] encode() throws DGCSchemaException {
        try {
            byte[] encoding = cborMapper.writeValueAsBytes((Object)this);
            if (this.tagDateTimes) {
                boolean containsTestEntries;
                boolean bl = containsTestEntries = this.getT() != null && this.getT().size() > 0;
                if (!containsTestEntries) {
                    return encoding;
                }
                CBORObject obj = CBORObject.DecodeFromBytes((byte[])encoding);
                CBORObject tArr = obj.get("t");
                for (int i = 0; i < tArr.size(); ++i) {
                    CBORObject tObj = tArr.get(i);
                    CBORObject sc = tObj.get("sc");
                    if (sc == null || sc.HasMostOuterTag(0)) continue;
                    tObj.set("sc", CBORObject.FromObjectAndTag((Object)sc, (int)0));
                }
                return obj.EncodeToBytes();
            }
            return encoding;
        }
        catch (JsonProcessingException e) {
            throw new DGCSchemaException("Failed to serialize to CBOR", e);
        }
    }

    public static DigitalCovidCertificate decode(byte[] cbor) throws DGCSchemaException {
        try {
            return (DigitalCovidCertificate)cborMapper.readValue(cbor, DigitalCovidCertificate.class);
        }
        catch (IOException e) {
            throw new DGCSchemaException("Failed to decode DCC from CBOR encoding", e);
        }
    }

    public String toJSONString() throws DGCSchemaException {
        try {
            return jsonMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new DGCSchemaException("Failed to serialize to JSON", e);
        }
    }

    public static DigitalCovidCertificate fromJsonString(String json) throws DGCSchemaException {
        try {
            return (DigitalCovidCertificate)jsonMapper.readValue(json, DigitalCovidCertificate.class);
        }
        catch (IOException e) {
            throw new DGCSchemaException("Failed to decode DCC from JSON", e);
        }
    }

    public static CBORMapper getCBORMapper() {
        return cborMapper;
    }

    public static ObjectMapper getJSONMapper() {
        return jsonMapper;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public void setTagDateTimes(boolean tagDateTimes) {
        this.tagDateTimes = tagDateTimes;
    }

    static {
        JavaTimeModule timeModule = new JavaTimeModule();
        timeModule.addDeserializer(Instant.class, (JsonDeserializer)CustomInstantDeserializer.INSTANT);
        timeModule.addSerializer(Instant.class, (JsonSerializer)CustomInstantSerializer.INSTANCE);
        cborMapper.registerModule((Module)timeModule);
        cborMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        cborMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        cborMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        jsonMapper.registerModule((Module)timeModule);
        jsonMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    private static class CustomInstantSerializer
    extends InstantSerializer {
        private static final long serialVersionUID = 4972433067449374883L;
        public static final CustomInstantSerializer INSTANCE = new CustomInstantSerializer();

        protected CustomInstantSerializer() {
            super(InstantSerializer.INSTANCE, Boolean.valueOf(false), Boolean.valueOf(false), new DateTimeFormatterBuilder().appendInstant(0).toFormatter());
        }
    }

    private static class CustomInstantDeserializer
    extends InstantDeserializer<Instant> {
        private static final long serialVersionUID = 3929100820024454525L;
        public static final CustomInstantDeserializer INSTANT = new CustomInstantDeserializer(Instant.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, Instant::from, a -> Instant.ofEpochMilli(a.value), a -> Instant.ofEpochSecond(a.integer, a.fraction), null, true);

        protected CustomInstantDeserializer(Class<Instant> supportedType, DateTimeFormatter formatter, Function<TemporalAccessor, Instant> parsedToValue, Function<InstantDeserializer.FromIntegerArguments, Instant> fromMilliseconds, Function<InstantDeserializer.FromDecimalArguments, Instant> fromNanoseconds, BiFunction<Instant, ZoneId, Instant> adjust, boolean replaceZeroOffsetAsZ) {
            super(supportedType, formatter, parsedToValue, fromMilliseconds, fromNanoseconds, adjust, replaceZeroOffsetAsZ);
        }
    }
}

