/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.payload.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.LocalDate;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"tg", "fr", "co", "is", "df", "du", "ci"})
public class RecoveryEntry {
    @JsonProperty(value="tg")
    @JsonPropertyDescription(value="EU eHealthNetwork: Value Sets for Digital Covid Certificates. version 1.0, 2021-04-16, section 2.1")
    @NotNull
    private String tg;
    @JsonProperty(value="fr")
    @JsonPropertyDescription(value="ISO 8601 complete date of first positive NAA test result")
    @NotNull
    private LocalDate fr;
    @JsonProperty(value="co")
    @JsonPropertyDescription(value="Country of Vaccination / Test, ISO 3166 alpha-2 where possible")
    @Pattern(regexp="[A-Z]{1,10}")
    @NotNull
    private @Pattern(regexp="[A-Z]{1,10}") @NotNull String co;
    @JsonProperty(value="is")
    @JsonPropertyDescription(value="Certificate Issuer")
    @Size(max=80)
    @NotNull
    private @Size(max=80) @NotNull String is;
    @JsonProperty(value="df")
    @JsonPropertyDescription(value="ISO 8601 complete date: Certificate Valid From")
    @NotNull
    private LocalDate df;
    @JsonProperty(value="du")
    @JsonPropertyDescription(value="ISO 8601 complete date: Certificate Valid Until")
    @NotNull
    private LocalDate du;
    @JsonProperty(value="ci")
    @JsonPropertyDescription(value="Certificate Identifier, format as per UVCI: Annex 2 in  https://ec.europa.eu/health/sites/health/files/ehealth/docs/vaccination-proof_interoperability-guidelines_en.pdf")
    @Size(max=80)
    @NotNull
    private @Size(max=80) @NotNull String ci;

    public RecoveryEntry() {
    }

    public RecoveryEntry(String tg, LocalDate fr, String co, String is, LocalDate df, LocalDate du, String ci) {
        this.tg = tg;
        this.fr = fr;
        this.co = co;
        this.is = is;
        this.df = df;
        this.du = du;
        this.ci = ci;
    }

    @JsonProperty(value="tg")
    public String getTg() {
        return this.tg;
    }

    @JsonProperty(value="tg")
    public void setTg(String tg) {
        this.tg = tg;
    }

    public RecoveryEntry withTg(String tg) {
        this.tg = tg;
        return this;
    }

    @JsonProperty(value="fr")
    public LocalDate getFr() {
        return this.fr;
    }

    @JsonProperty(value="fr")
    public void setFr(LocalDate fr) {
        this.fr = fr;
    }

    public RecoveryEntry withFr(LocalDate fr) {
        this.fr = fr;
        return this;
    }

    @JsonProperty(value="co")
    public String getCo() {
        return this.co;
    }

    @JsonProperty(value="co")
    public void setCo(String co) {
        this.co = co;
    }

    public RecoveryEntry withCo(String co) {
        this.co = co;
        return this;
    }

    @JsonProperty(value="is")
    public String getIs() {
        return this.is;
    }

    @JsonProperty(value="is")
    public void setIs(String is) {
        this.is = is;
    }

    public RecoveryEntry withIs(String is) {
        this.is = is;
        return this;
    }

    @JsonProperty(value="df")
    public LocalDate getDf() {
        return this.df;
    }

    @JsonProperty(value="df")
    public void setDf(LocalDate df) {
        this.df = df;
    }

    public RecoveryEntry withDf(LocalDate df) {
        this.df = df;
        return this;
    }

    @JsonProperty(value="du")
    public LocalDate getDu() {
        return this.du;
    }

    @JsonProperty(value="du")
    public void setDu(LocalDate du) {
        this.du = du;
    }

    public RecoveryEntry withDu(LocalDate du) {
        this.du = du;
        return this;
    }

    @JsonProperty(value="ci")
    public String getCi() {
        return this.ci;
    }

    @JsonProperty(value="ci")
    public void setCi(String ci) {
        this.ci = ci;
    }

    public RecoveryEntry withCi(String ci) {
        this.ci = ci;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RecoveryEntry.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("tg");
        sb.append('=');
        sb.append(this.tg == null ? "<null>" : this.tg);
        sb.append(',');
        sb.append("fr");
        sb.append('=');
        sb.append(this.fr == null ? "<null>" : this.fr);
        sb.append(',');
        sb.append("co");
        sb.append('=');
        sb.append(this.co == null ? "<null>" : this.co);
        sb.append(',');
        sb.append("is");
        sb.append('=');
        sb.append(this.is == null ? "<null>" : this.is);
        sb.append(',');
        sb.append("df");
        sb.append('=');
        sb.append(this.df == null ? "<null>" : this.df);
        sb.append(',');
        sb.append("du");
        sb.append('=');
        sb.append(this.du == null ? "<null>" : this.du);
        sb.append(',');
        sb.append("ci");
        sb.append('=');
        sb.append(this.ci == null ? "<null>" : this.ci);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.du == null ? 0 : this.du.hashCode());
        result = result * 31 + (this.df == null ? 0 : this.df.hashCode());
        result = result * 31 + (this.tg == null ? 0 : this.tg.hashCode());
        result = result * 31 + (this.ci == null ? 0 : this.ci.hashCode());
        result = result * 31 + (this.is == null ? 0 : this.is.hashCode());
        result = result * 31 + (this.fr == null ? 0 : this.fr.hashCode());
        result = result * 31 + (this.co == null ? 0 : this.co.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RecoveryEntry)) {
            return false;
        }
        RecoveryEntry rhs = (RecoveryEntry)other;
        return (this.du == rhs.du || this.du != null && this.du.equals(rhs.du)) && (this.df == rhs.df || this.df != null && this.df.equals(rhs.df)) && (this.tg == rhs.tg || this.tg != null && this.tg.equals(rhs.tg)) && (this.ci == rhs.ci || this.ci != null && this.ci.equals(rhs.ci)) && (this.is == rhs.is || this.is != null && this.is.equals(rhs.is)) && (this.fr == rhs.fr || this.fr != null && this.fr.equals(rhs.fr)) && (this.co == rhs.co || this.co != null && this.co.equals(rhs.co));
    }
}

