/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.payload.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.Instant;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"tg", "tt", "nm", "ma", "sc", "tr", "tc", "co", "is", "ci"})
public class TestEntry {
    @JsonProperty(value="tg")
    @JsonPropertyDescription(value="EU eHealthNetwork: Value Sets for Digital Covid Certificates. version 1.0, 2021-04-16, section 2.1")
    @NotNull
    private String tg;
    @JsonProperty(value="tt")
    @JsonPropertyDescription(value="EU eHealthNetwork: Value Sets for Digital Covid Certificates. version 1.0, 2021-04-16, section 2.7")
    @NotNull
    private String tt;
    @JsonProperty(value="nm")
    @JsonPropertyDescription(value="NAA Test Name")
    @Size(max=80)
    private @Size(max=80) String nm;
    @JsonProperty(value="ma")
    @JsonPropertyDescription(value="EU eHealthNetwork: Value Sets for Digital Covid Certificates. version 1.0, 2021-04-16, section 2.8")
    private String ma;
    @JsonProperty(value="sc")
    @JsonPropertyDescription(value="Date/Time of Sample Collection")
    @NotNull
    private Instant sc;
    @JsonProperty(value="tr")
    @JsonPropertyDescription(value="EU eHealthNetwork: Value Sets for Digital Covid Certificates. version 1.0, 2021-04-16, section 2.9")
    @NotNull
    private String tr;
    @JsonProperty(value="tc")
    @JsonPropertyDescription(value="Testing Centre")
    @Size(max=80)
    private @Size(max=80) String tc;
    @JsonProperty(value="co")
    @JsonPropertyDescription(value="Country of Vaccination / Test, ISO 3166 alpha-2 where possible")
    @Pattern(regexp="[A-Z]{1,10}")
    @NotNull
    private @Pattern(regexp="[A-Z]{1,10}") @NotNull String co;
    @JsonProperty(value="is")
    @JsonPropertyDescription(value="Certificate Issuer")
    @Size(max=80)
    @NotNull
    private @Size(max=80) @NotNull String is;
    @JsonProperty(value="ci")
    @JsonPropertyDescription(value="Certificate Identifier, format as per UVCI: Annex 2 in  https://ec.europa.eu/health/sites/health/files/ehealth/docs/vaccination-proof_interoperability-guidelines_en.pdf")
    @Size(max=80)
    @NotNull
    private @Size(max=80) @NotNull String ci;

    public TestEntry() {
    }

    public TestEntry(String tg, String tt, String nm, String ma, Instant sc, String tr, String tc, String co, String is, String ci) {
        this.tg = tg;
        this.tt = tt;
        this.nm = nm;
        this.ma = ma;
        this.sc = sc;
        this.tr = tr;
        this.tc = tc;
        this.co = co;
        this.is = is;
        this.ci = ci;
    }

    @JsonProperty(value="tg")
    public String getTg() {
        return this.tg;
    }

    @JsonProperty(value="tg")
    public void setTg(String tg) {
        this.tg = tg;
    }

    public TestEntry withTg(String tg) {
        this.tg = tg;
        return this;
    }

    @JsonProperty(value="tt")
    public String getTt() {
        return this.tt;
    }

    @JsonProperty(value="tt")
    public void setTt(String tt) {
        this.tt = tt;
    }

    public TestEntry withTt(String tt) {
        this.tt = tt;
        return this;
    }

    @JsonProperty(value="nm")
    public String getNm() {
        return this.nm;
    }

    @JsonProperty(value="nm")
    public void setNm(String nm) {
        this.nm = nm;
    }

    public TestEntry withNm(String nm) {
        this.nm = nm;
        return this;
    }

    @JsonProperty(value="ma")
    public String getMa() {
        return this.ma;
    }

    @JsonProperty(value="ma")
    public void setMa(String ma) {
        this.ma = ma;
    }

    public TestEntry withMa(String ma) {
        this.ma = ma;
        return this;
    }

    @JsonProperty(value="sc")
    public Instant getSc() {
        return this.sc;
    }

    @JsonProperty(value="sc")
    public void setSc(Instant sc) {
        this.sc = sc;
    }

    public TestEntry withSc(Instant sc) {
        this.sc = sc;
        return this;
    }

    @JsonProperty(value="tr")
    public String getTr() {
        return this.tr;
    }

    @JsonProperty(value="tr")
    public void setTr(String tr) {
        this.tr = tr;
    }

    public TestEntry withTr(String tr) {
        this.tr = tr;
        return this;
    }

    @JsonProperty(value="tc")
    public String getTc() {
        return this.tc;
    }

    @JsonProperty(value="tc")
    public void setTc(String tc) {
        this.tc = tc;
    }

    public TestEntry withTc(String tc) {
        this.tc = tc;
        return this;
    }

    @JsonProperty(value="co")
    public String getCo() {
        return this.co;
    }

    @JsonProperty(value="co")
    public void setCo(String co) {
        this.co = co;
    }

    public TestEntry withCo(String co) {
        this.co = co;
        return this;
    }

    @JsonProperty(value="is")
    public String getIs() {
        return this.is;
    }

    @JsonProperty(value="is")
    public void setIs(String is) {
        this.is = is;
    }

    public TestEntry withIs(String is) {
        this.is = is;
        return this;
    }

    @JsonProperty(value="ci")
    public String getCi() {
        return this.ci;
    }

    @JsonProperty(value="ci")
    public void setCi(String ci) {
        this.ci = ci;
    }

    public TestEntry withCi(String ci) {
        this.ci = ci;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestEntry.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("tg");
        sb.append('=');
        sb.append(this.tg == null ? "<null>" : this.tg);
        sb.append(',');
        sb.append("tt");
        sb.append('=');
        sb.append(this.tt == null ? "<null>" : this.tt);
        sb.append(',');
        sb.append("nm");
        sb.append('=');
        sb.append(this.nm == null ? "<null>" : this.nm);
        sb.append(',');
        sb.append("ma");
        sb.append('=');
        sb.append(this.ma == null ? "<null>" : this.ma);
        sb.append(',');
        sb.append("sc");
        sb.append('=');
        sb.append(this.sc == null ? "<null>" : this.sc);
        sb.append(',');
        sb.append("tr");
        sb.append('=');
        sb.append(this.tr == null ? "<null>" : this.tr);
        sb.append(',');
        sb.append("tc");
        sb.append('=');
        sb.append(this.tc == null ? "<null>" : this.tc);
        sb.append(',');
        sb.append("co");
        sb.append('=');
        sb.append(this.co == null ? "<null>" : this.co);
        sb.append(',');
        sb.append("is");
        sb.append('=');
        sb.append(this.is == null ? "<null>" : this.is);
        sb.append(',');
        sb.append("ci");
        sb.append('=');
        sb.append(this.ci == null ? "<null>" : this.ci);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.tt == null ? 0 : this.tt.hashCode());
        result = result * 31 + (this.sc == null ? 0 : this.sc.hashCode());
        result = result * 31 + (this.tg == null ? 0 : this.tg.hashCode());
        result = result * 31 + (this.ma == null ? 0 : this.ma.hashCode());
        result = result * 31 + (this.ci == null ? 0 : this.ci.hashCode());
        result = result * 31 + (this.is == null ? 0 : this.is.hashCode());
        result = result * 31 + (this.co == null ? 0 : this.co.hashCode());
        result = result * 31 + (this.tr == null ? 0 : this.tr.hashCode());
        result = result * 31 + (this.nm == null ? 0 : this.nm.hashCode());
        result = result * 31 + (this.tc == null ? 0 : this.tc.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TestEntry)) {
            return false;
        }
        TestEntry rhs = (TestEntry)other;
        return (this.tt == rhs.tt || this.tt != null && this.tt.equals(rhs.tt)) && (this.sc == rhs.sc || this.sc != null && this.sc.equals(rhs.sc)) && (this.tg == rhs.tg || this.tg != null && this.tg.equals(rhs.tg)) && (this.ma == rhs.ma || this.ma != null && this.ma.equals(rhs.ma)) && (this.ci == rhs.ci || this.ci != null && this.ci.equals(rhs.ci)) && (this.is == rhs.is || this.is != null && this.is.equals(rhs.is)) && (this.co == rhs.co || this.co != null && this.co.equals(rhs.co)) && (this.tr == rhs.tr || this.tr != null && this.tr.equals(rhs.tr)) && (this.nm == rhs.nm || this.nm != null && this.nm.equals(rhs.nm)) && (this.tc == rhs.tc || this.tc != null && this.tc.equals(rhs.tc));
    }
}

