/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.valueset.v1;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.digg.dgc.valueset.v1.ValueSet;

public abstract class AbstractValueSetSupplier<T>
implements Supplier<ValueSet> {
    private static final Logger log = LoggerFactory.getLogger(AbstractValueSetSupplier.class);
    private final T resource;
    private final Duration refreshRate;
    private ValueSet cache;
    private Instant lastUpdate;

    public AbstractValueSetSupplier(T resource, Duration refreshRate) throws IOException {
        this.resource = resource;
        this.refreshRate = refreshRate;
        this.update();
    }

    @Override
    public final synchronized ValueSet get() {
        if (this.needsUpdate()) {
            try {
                this.update();
            }
            catch (IOException e) {
                log.error("Failed to update DCC ValueSet '{}' from {} - Using cache", new Object[]{this.cache.getId(), this.getResourceString(this.resource), e});
            }
        }
        return this.cache;
    }

    private boolean needsUpdate() {
        if (this.lastUpdate == null) {
            return true;
        }
        return Instant.now().minus(this.refreshRate).isAfter(this.lastUpdate);
    }

    private void update() throws IOException {
        ValueSet valueSet = this.getValueSet(this.resource);
        if (valueSet == null) {
            throw new IOException("No ValueSet available");
        }
        this.cache = valueSet;
        this.lastUpdate = Instant.now();
        log.debug("ValueSet '{}' was updated - date/version is: {}", (Object)this.cache.getId(), (Object)this.cache.getDate());
    }

    protected abstract ValueSet getValueSet(T var1) throws IOException;

    protected abstract String getResourceString(T var1);
}

