/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.valueset.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import se.digg.dgc.valueset.v1.ValueSetValue;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"valueSetId", "valueSetDate", "valueSetValues"})
public class ValueSet {
    private static ObjectMapper jsonMapper = new ObjectMapper();
    @JsonProperty(value="valueSetId")
    @JsonPropertyDescription(value="Value Set Identifier")
    @NotNull
    private String id;
    @JsonProperty(value="valueSetDate")
    @JsonPropertyDescription(value="Value Set Version")
    @NotNull
    private LocalDate date;
    @JsonProperty(value="valueSetValues")
    @JsonPropertyDescription(value="Allowed values in Value Set")
    @NotNull
    private Map<String, ValueSetValue> values;

    public ValueSet() {
    }

    public ValueSet(String id, LocalDate date, Map<String, ValueSetValue> values) {
        this.id = Optional.ofNullable(id).orElseThrow(() -> new IllegalArgumentException("valueSetId is required"));
        this.date = date;
        this.values = values;
    }

    public ValueSet(InputStream stream) throws IOException {
        this((ValueSet)jsonMapper.readValue(stream, ValueSet.class));
    }

    protected ValueSet(ValueSet valueSet) {
        this(valueSet.getId(), valueSet.getDate(), valueSet.getValues());
    }

    public ValueSetValue getValue(String code) {
        return this.getValues().get(code);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = Optional.ofNullable(id).orElseThrow(() -> new IllegalArgumentException("valueSetId is required"));
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Map<String, ValueSetValue> getValues() {
        return this.values != null ? this.values : Collections.emptyMap();
    }

    public void setValues(Map<String, ValueSetValue> values) {
        this.values = values;
    }

    public String toString() {
        return String.format("ValueSet [id='%s', date='%s', values=%s]", this.id, this.date, this.values);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.id, this.values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ValueSet)) {
            return false;
        }
        ValueSet other = (ValueSet)obj;
        return Objects.equals(this.date, other.date) && Objects.equals(this.id, other.id) && Objects.equals(this.values, other.values);
    }

    static {
        jsonMapper.registerModule((Module)new JavaTimeModule());
        jsonMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }
}

