/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.valueset.v1.validation;

import java.util.List;
import java.util.Optional;
import se.digg.dgc.payload.v1.Eudcc;
import se.digg.dgc.payload.v1.RecoveryEntry;
import se.digg.dgc.payload.v1.TestEntry;
import se.digg.dgc.payload.v1.VaccinationEntry;
import se.digg.dgc.valueset.v1.ValueSet;
import se.digg.dgc.valueset.v1.ValueSetValue;
import se.digg.dgc.valueset.v1.validation.ValueSetValidationResult;
import se.digg.dgc.valueset.v1.validation.ValueSetValidator;

public class DefaultValueSetValidator
implements ValueSetValidator {
    private final List<ValueSet> valueSets;

    public DefaultValueSetValidator(List<ValueSet> valueSets) {
        this.valueSets = Optional.ofNullable(valueSets).orElseThrow(() -> new IllegalArgumentException("valueSets must not be null"));
    }

    @Override
    public ValueSetValidationResult validate(Eudcc dcc) {
        int i;
        ValueSetValidationResult result = new ValueSetValidationResult();
        if (dcc.getV() != null) {
            for (i = 0; i < dcc.getV().size(); ++i) {
                result.addChildResult(this.validate(dcc.getV().get(i), "v[" + i + "]"));
            }
        }
        if (dcc.getT() != null) {
            for (i = 0; i < dcc.getT().size(); ++i) {
                result.addChildResult(this.validate(dcc.getT().get(i), "t[" + i + "]"));
            }
        }
        if (dcc.getR() != null) {
            for (i = 0; i < dcc.getR().size(); ++i) {
                result.addChildResult(this.validate(dcc.getR().get(i), "r[" + i + "]"));
            }
        }
        return result;
    }

    @Override
    public ValueSetValidationResult validate(VaccinationEntry vaccination) {
        return this.validate(vaccination, null);
    }

    private ValueSetValidationResult validate(VaccinationEntry vaccination, String propertyName) {
        ValueSetValidationResult result = new ValueSetValidationResult(propertyName);
        result.addChildResult(this.checkValue(vaccination.getTg(), "tg", "disease-agent-targeted"));
        result.addChildResult(this.checkValue(vaccination.getVp(), "vp", "sct-vaccines-covid-19"));
        result.addChildResult(this.checkValue(vaccination.getMp(), "mp", "vaccines-covid-19-names"));
        result.addChildResult(this.checkValue(vaccination.getMa(), "ma", "vaccines-covid-19-auth-holders"));
        return result;
    }

    @Override
    public ValueSetValidationResult validate(TestEntry testEntry) {
        return this.validate(testEntry, null);
    }

    private ValueSetValidationResult validate(TestEntry testEntry, String propertyName) {
        ValueSetValidationResult result = new ValueSetValidationResult(propertyName);
        result.addChildResult(this.checkValue(testEntry.getTg(), "tg", "disease-agent-targeted"));
        result.addChildResult(this.checkValue(testEntry.getTt(), "tt", "covid-19-lab-test-type"));
        result.addChildResult(this.checkValue(testEntry.getMa(), "ma", "covid-19-lab-test-manufacturer-and-name"));
        result.addChildResult(this.checkValue(testEntry.getTr(), "tr", "covid-19-lab-result"));
        return result;
    }

    @Override
    public ValueSetValidationResult validate(RecoveryEntry recoveryEntry) {
        return this.validate(recoveryEntry, null);
    }

    private ValueSetValidationResult validate(RecoveryEntry recoveryEntry, String propertyName) {
        ValueSetValidationResult result = new ValueSetValidationResult(propertyName);
        result.addChildResult(this.checkValue(recoveryEntry.getTg(), "tg", "disease-agent-targeted"));
        return result;
    }

    private ValueSetValidationResult checkValue(String value, String propertyName, String valueSetId) {
        if (value == null) {
            return null;
        }
        ValueSet valueSet = this.valueSets.stream().filter(vs -> valueSetId.equals(vs.getId())).findFirst().orElse(null);
        if (valueSet == null) {
            return new ValueSetValidationResult(propertyName, ValueSetValidationResult.Status.UNDETERMINE, String.format("No '%s' value-set installed - cannot perform check of '%s'", valueSetId, propertyName));
        }
        ValueSetValue vsv = valueSet.getValue(value);
        if (vsv == null) {
            return new ValueSetValidationResult(propertyName, ValueSetValidationResult.Status.ERROR, String.format("Value for '%s' (%s) is not valid according to value-set '%s'", propertyName, value, valueSetId));
        }
        return new ValueSetValidationResult(propertyName, ValueSetValidationResult.Status.SUCCESS, String.format("Value for '%s' is in value-set '%s'", propertyName, valueSetId));
    }
}

