/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.valueset.v1.validation;

import java.util.ArrayList;
import java.util.List;

public class ValueSetValidationResult {
    private Status result;
    private String propertyName;
    private String message;
    private final List<ValueSetValidationResult> children = new ArrayList<ValueSetValidationResult>();

    public ValueSetValidationResult() {
        this.result = Status.SUCCESS;
    }

    public ValueSetValidationResult(String propertyName) {
        this();
        this.propertyName = propertyName;
    }

    public ValueSetValidationResult(String propertyName, Status result, String message) {
        this(propertyName);
        this.result = result;
        this.message = message;
    }

    public boolean isSuccess() {
        return this.result == Status.SUCCESS;
    }

    public void addChildResult(ValueSetValidationResult childResult) {
        String childProperty;
        if (childResult == null) {
            return;
        }
        String string = childProperty = this.propertyName != null ? this.propertyName + "." + childResult.getPropertyName() : childResult.getPropertyName();
        if (childResult.getResult() == Status.UNDETERMINE && this.result != Status.ERROR) {
            this.result = Status.UNDETERMINE;
        } else if (childResult.getResult() == Status.ERROR) {
            this.result = Status.ERROR;
        }
        String msg = String.format("%s", childResult.getMessage() != null ? childResult.getMessage() : childResult.getResult());
        this.message = this.message != null ? String.format("%s, %s", this.message, msg) : msg;
        ValueSetValidationResult vr = new ValueSetValidationResult(childProperty, childResult.getResult(), childResult.getMessage());
        childResult.getChildren().forEach(vr::addChildResult);
        this.children.add(vr);
    }

    public Status getResult() {
        return this.result;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getMessage() {
        return this.message;
    }

    public List<ValueSetValidationResult> getChildren() {
        return this.children;
    }

    public String toString() {
        return String.format("ValueSetValidationResult [result=%s, propertyName='%s', message='%s', children=%d]", new Object[]{this.result, this.propertyName, this.message, this.children.size()});
    }

    public static enum Status {
        SUCCESS,
        UNDETERMINE,
        ERROR;

    }
}

