/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.payload.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import se.digg.dgc.payload.v1.PersonName;
import se.digg.dgc.payload.v1.RecoveryEntry;
import se.digg.dgc.payload.v1.TestEntry;
import se.digg.dgc.payload.v1.VaccinationEntry;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"ver", "nam", "dob", "v", "t", "r"})
public class Eudcc {
    @JsonProperty(value="ver")
    @JsonPropertyDescription(value="Version of the schema, according to Semantic versioning (ISO, https://semver.org/ version 2.0.0 or newer)")
    @Pattern(regexp="^\\d+.\\d+.\\d+$")
    private @Pattern(regexp="^\\d+.\\d+.\\d+$") String ver;
    @JsonProperty(value="nam")
    @JsonPropertyDescription(value="Person name: Surname(s), forename(s) - in that order")
    @Valid
    private PersonName nam;
    @JsonProperty(value="dob")
    @JsonPropertyDescription(value="Date of Birth of the person addressed in the DCC. ISO 8601 date format restricted to range 1900-2099 or empty")
    @Pattern(regexp="^((19|20)\\d\\d(-\\d\\d){0,2}){0,1}$")
    private @Pattern(regexp="^((19|20)\\d\\d(-\\d\\d){0,2}){0,1}$") String dob;
    @JsonProperty(value="v")
    @JsonPropertyDescription(value="Vaccination Group")
    @Size(min=1, max=1)
    @Valid
    private @Size(min=1, max=1) @Valid List<VaccinationEntry> v = null;
    @JsonProperty(value="t")
    @JsonPropertyDescription(value="Test Group")
    @Size(min=1, max=1)
    @Valid
    private @Size(min=1, max=1) @Valid List<TestEntry> t = null;
    @JsonProperty(value="r")
    @JsonPropertyDescription(value="Recovery Group")
    @Size(min=1, max=1)
    @Valid
    private @Size(min=1, max=1) @Valid List<RecoveryEntry> r = null;

    public Eudcc() {
    }

    public Eudcc(String ver, PersonName nam, String dob, List<VaccinationEntry> v, List<TestEntry> t, List<RecoveryEntry> r) {
        this.ver = ver;
        this.nam = nam;
        this.dob = dob;
        this.v = v;
        this.t = t;
        this.r = r;
    }

    @JsonProperty(value="ver")
    public String getVer() {
        return this.ver;
    }

    @JsonProperty(value="ver")
    public void setVer(String ver) {
        this.ver = ver;
    }

    public Eudcc withVer(String ver) {
        this.ver = ver;
        return this;
    }

    @JsonProperty(value="nam")
    public PersonName getNam() {
        return this.nam;
    }

    @JsonProperty(value="nam")
    public void setNam(PersonName nam) {
        this.nam = nam;
    }

    public Eudcc withNam(PersonName nam) {
        this.nam = nam;
        return this;
    }

    @JsonProperty(value="dob")
    public String getDob() {
        return this.dob;
    }

    @JsonProperty(value="dob")
    public void setDob(String dob) {
        this.dob = dob;
    }

    public Eudcc withDob(String dob) {
        this.dob = dob;
        return this;
    }

    @JsonProperty(value="v")
    public List<VaccinationEntry> getV() {
        return this.v;
    }

    @JsonProperty(value="v")
    public void setV(List<VaccinationEntry> v) {
        this.v = v;
    }

    public Eudcc withV(List<VaccinationEntry> v) {
        this.v = v;
        return this;
    }

    @JsonProperty(value="t")
    public List<TestEntry> getT() {
        return this.t;
    }

    @JsonProperty(value="t")
    public void setT(List<TestEntry> t) {
        this.t = t;
    }

    public Eudcc withT(List<TestEntry> t) {
        this.t = t;
        return this;
    }

    @JsonProperty(value="r")
    public List<RecoveryEntry> getR() {
        return this.r;
    }

    @JsonProperty(value="r")
    public void setR(List<RecoveryEntry> r) {
        this.r = r;
    }

    public Eudcc withR(List<RecoveryEntry> r) {
        this.r = r;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Eudcc.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("ver");
        sb.append('=');
        sb.append(this.ver == null ? "<null>" : this.ver);
        sb.append(',');
        sb.append("nam");
        sb.append('=');
        sb.append(this.nam == null ? "<null>" : this.nam);
        sb.append(',');
        sb.append("dob");
        sb.append('=');
        sb.append(this.dob == null ? "<null>" : this.dob);
        sb.append(',');
        sb.append("v");
        sb.append('=');
        sb.append(this.v == null ? "<null>" : this.v);
        sb.append(',');
        sb.append("t");
        sb.append('=');
        sb.append(this.t == null ? "<null>" : this.t);
        sb.append(',');
        sb.append("r");
        sb.append('=');
        sb.append(this.r == null ? "<null>" : this.r);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.ver == null ? 0 : this.ver.hashCode());
        result = result * 31 + (this.r == null ? 0 : this.r.hashCode());
        result = result * 31 + (this.t == null ? 0 : this.t.hashCode());
        result = result * 31 + (this.dob == null ? 0 : this.dob.hashCode());
        result = result * 31 + (this.v == null ? 0 : this.v.hashCode());
        result = result * 31 + (this.nam == null ? 0 : this.nam.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Eudcc)) {
            return false;
        }
        Eudcc rhs = (Eudcc)other;
        return (this.ver == rhs.ver || this.ver != null && this.ver.equals(rhs.ver)) && (this.r == rhs.r || this.r != null && this.r.equals(rhs.r)) && (this.t == rhs.t || this.t != null && this.t.equals(rhs.t)) && (this.dob == rhs.dob || this.dob != null && this.dob.equals(rhs.dob)) && (this.v == rhs.v || this.v != null && this.v.equals(rhs.v)) && (this.nam == rhs.nam || this.nam != null && this.nam.equals(rhs.nam));
    }
}

