/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.payload.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fn", "fnt", "gn", "gnt"})
public class PersonName {
    @JsonProperty(value="fn")
    @JsonPropertyDescription(value="The surname or primary name(s) of the person addressed in the certificate")
    @Size(max=80)
    private @Size(max=80) String fn;
    @JsonProperty(value="fnt")
    @JsonPropertyDescription(value="The surname(s) of the person, transliterated ICAO 9303")
    @Pattern(regexp="^[A-Z<]*$")
    @Size(max=80)
    @NotNull
    private @Pattern(regexp="^[A-Z<]*$") @Size(max=80) @NotNull String fnt;
    @JsonProperty(value="gn")
    @JsonPropertyDescription(value="The forename(s) of the person addressed in the certificate")
    @Size(max=80)
    private @Size(max=80) String gn;
    @JsonProperty(value="gnt")
    @JsonPropertyDescription(value="The forename(s) of the person, transliterated ICAO 9303")
    @Pattern(regexp="^[A-Z<]*$")
    @Size(max=80)
    private @Pattern(regexp="^[A-Z<]*$") @Size(max=80) String gnt;

    public PersonName() {
    }

    public PersonName(String fn, String fnt, String gn, String gnt) {
        this.fn = fn;
        this.fnt = fnt;
        this.gn = gn;
        this.gnt = gnt;
    }

    @JsonProperty(value="fn")
    public String getFn() {
        return this.fn;
    }

    @JsonProperty(value="fn")
    public void setFn(String fn) {
        this.fn = fn;
    }

    public PersonName withFn(String fn) {
        this.fn = fn;
        return this;
    }

    @JsonProperty(value="fnt")
    public String getFnt() {
        return this.fnt;
    }

    @JsonProperty(value="fnt")
    public void setFnt(String fnt) {
        this.fnt = fnt;
    }

    public PersonName withFnt(String fnt) {
        this.fnt = fnt;
        return this;
    }

    @JsonProperty(value="gn")
    public String getGn() {
        return this.gn;
    }

    @JsonProperty(value="gn")
    public void setGn(String gn) {
        this.gn = gn;
    }

    public PersonName withGn(String gn) {
        this.gn = gn;
        return this;
    }

    @JsonProperty(value="gnt")
    public String getGnt() {
        return this.gnt;
    }

    @JsonProperty(value="gnt")
    public void setGnt(String gnt) {
        this.gnt = gnt;
    }

    public PersonName withGnt(String gnt) {
        this.gnt = gnt;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PersonName.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("fn");
        sb.append('=');
        sb.append(this.fn == null ? "<null>" : this.fn);
        sb.append(',');
        sb.append("fnt");
        sb.append('=');
        sb.append(this.fnt == null ? "<null>" : this.fnt);
        sb.append(',');
        sb.append("gn");
        sb.append('=');
        sb.append(this.gn == null ? "<null>" : this.gn);
        sb.append(',');
        sb.append("gnt");
        sb.append('=');
        sb.append(this.gnt == null ? "<null>" : this.gnt);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.fn == null ? 0 : this.fn.hashCode());
        result = result * 31 + (this.gnt == null ? 0 : this.gnt.hashCode());
        result = result * 31 + (this.fnt == null ? 0 : this.fnt.hashCode());
        result = result * 31 + (this.gn == null ? 0 : this.gn.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PersonName)) {
            return false;
        }
        PersonName rhs = (PersonName)other;
        return (this.fn == rhs.fn || this.fn != null && this.fn.equals(rhs.fn)) && (this.gnt == rhs.gnt || this.gnt != null && this.gnt.equals(rhs.gnt)) && (this.fnt == rhs.fnt || this.fnt != null && this.fnt.equals(rhs.fnt)) && (this.gn == rhs.gn || this.gn != null && this.gn.equals(rhs.gn));
    }
}

