/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.payload.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.LocalDate;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"tg", "vp", "mp", "ma", "dn", "sd", "dt", "co", "is", "ci"})
public class VaccinationEntry {
    @JsonProperty(value="tg")
    @JsonPropertyDescription(value="EU eHealthNetwork: Value Sets for Digital Covid Certificates. version 1.0, 2021-04-16, section 2.1")
    @NotNull
    private String tg;
    @JsonProperty(value="vp")
    @JsonPropertyDescription(value="EU eHealthNetwork: Value Sets for Digital Covid Certificates. version 1.0, 2021-04-16, section 2.2")
    @NotNull
    private String vp;
    @JsonProperty(value="mp")
    @JsonPropertyDescription(value="EU eHealthNetwork: Value Sets for Digital Covid Certificates. version 1.0, 2021-04-16, section 2.3")
    @NotNull
    private String mp;
    @JsonProperty(value="ma")
    @JsonPropertyDescription(value="EU eHealthNetwork: Value Sets for Digital Covid Certificates. version 1.0, 2021-04-16, section 2.4")
    @NotNull
    private String ma;
    @JsonProperty(value="dn")
    @JsonPropertyDescription(value="Dose Number / Total doses in Series: positive integer")
    @DecimalMin(value="1")
    @NotNull
    private @DecimalMin(value="1") @NotNull Integer dn;
    @JsonProperty(value="sd")
    @JsonPropertyDescription(value="Dose Number / Total doses in Series: positive integer")
    @DecimalMin(value="1")
    @NotNull
    private @DecimalMin(value="1") @NotNull Integer sd;
    @JsonProperty(value="dt")
    @JsonPropertyDescription(value="ISO8601 complete date: Date of Vaccination")
    @NotNull
    private LocalDate dt;
    @JsonProperty(value="co")
    @JsonPropertyDescription(value="Country of Vaccination / Test, ISO 3166 alpha-2 where possible")
    @Pattern(regexp="[A-Z]{1,10}")
    @NotNull
    private @Pattern(regexp="[A-Z]{1,10}") @NotNull String co;
    @JsonProperty(value="is")
    @JsonPropertyDescription(value="Certificate Issuer")
    @Size(max=80)
    @NotNull
    private @Size(max=80) @NotNull String is;
    @JsonProperty(value="ci")
    @JsonPropertyDescription(value="Certificate Identifier, format as per UVCI: Annex 2 in  https://ec.europa.eu/health/sites/health/files/ehealth/docs/vaccination-proof_interoperability-guidelines_en.pdf")
    @Size(max=80)
    @NotNull
    private @Size(max=80) @NotNull String ci;

    public VaccinationEntry() {
    }

    public VaccinationEntry(String tg, String vp, String mp, String ma, Integer dn, Integer sd, LocalDate dt, String co, String is, String ci) {
        this.tg = tg;
        this.vp = vp;
        this.mp = mp;
        this.ma = ma;
        this.dn = dn;
        this.sd = sd;
        this.dt = dt;
        this.co = co;
        this.is = is;
        this.ci = ci;
    }

    @JsonProperty(value="tg")
    public String getTg() {
        return this.tg;
    }

    @JsonProperty(value="tg")
    public void setTg(String tg) {
        this.tg = tg;
    }

    public VaccinationEntry withTg(String tg) {
        this.tg = tg;
        return this;
    }

    @JsonProperty(value="vp")
    public String getVp() {
        return this.vp;
    }

    @JsonProperty(value="vp")
    public void setVp(String vp) {
        this.vp = vp;
    }

    public VaccinationEntry withVp(String vp) {
        this.vp = vp;
        return this;
    }

    @JsonProperty(value="mp")
    public String getMp() {
        return this.mp;
    }

    @JsonProperty(value="mp")
    public void setMp(String mp) {
        this.mp = mp;
    }

    public VaccinationEntry withMp(String mp) {
        this.mp = mp;
        return this;
    }

    @JsonProperty(value="ma")
    public String getMa() {
        return this.ma;
    }

    @JsonProperty(value="ma")
    public void setMa(String ma) {
        this.ma = ma;
    }

    public VaccinationEntry withMa(String ma) {
        this.ma = ma;
        return this;
    }

    @JsonProperty(value="dn")
    public Integer getDn() {
        return this.dn;
    }

    @JsonProperty(value="dn")
    public void setDn(Integer dn) {
        this.dn = dn;
    }

    public VaccinationEntry withDn(Integer dn) {
        this.dn = dn;
        return this;
    }

    @JsonProperty(value="sd")
    public Integer getSd() {
        return this.sd;
    }

    @JsonProperty(value="sd")
    public void setSd(Integer sd) {
        this.sd = sd;
    }

    public VaccinationEntry withSd(Integer sd) {
        this.sd = sd;
        return this;
    }

    @JsonProperty(value="dt")
    public LocalDate getDt() {
        return this.dt;
    }

    @JsonProperty(value="dt")
    public void setDt(LocalDate dt) {
        this.dt = dt;
    }

    public VaccinationEntry withDt(LocalDate dt) {
        this.dt = dt;
        return this;
    }

    @JsonProperty(value="co")
    public String getCo() {
        return this.co;
    }

    @JsonProperty(value="co")
    public void setCo(String co) {
        this.co = co;
    }

    public VaccinationEntry withCo(String co) {
        this.co = co;
        return this;
    }

    @JsonProperty(value="is")
    public String getIs() {
        return this.is;
    }

    @JsonProperty(value="is")
    public void setIs(String is) {
        this.is = is;
    }

    public VaccinationEntry withIs(String is) {
        this.is = is;
        return this;
    }

    @JsonProperty(value="ci")
    public String getCi() {
        return this.ci;
    }

    @JsonProperty(value="ci")
    public void setCi(String ci) {
        this.ci = ci;
    }

    public VaccinationEntry withCi(String ci) {
        this.ci = ci;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(VaccinationEntry.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("tg");
        sb.append('=');
        sb.append(this.tg == null ? "<null>" : this.tg);
        sb.append(',');
        sb.append("vp");
        sb.append('=');
        sb.append(this.vp == null ? "<null>" : this.vp);
        sb.append(',');
        sb.append("mp");
        sb.append('=');
        sb.append(this.mp == null ? "<null>" : this.mp);
        sb.append(',');
        sb.append("ma");
        sb.append('=');
        sb.append(this.ma == null ? "<null>" : this.ma);
        sb.append(',');
        sb.append("dn");
        sb.append('=');
        sb.append(this.dn == null ? "<null>" : this.dn);
        sb.append(',');
        sb.append("sd");
        sb.append('=');
        sb.append(this.sd == null ? "<null>" : this.sd);
        sb.append(',');
        sb.append("dt");
        sb.append('=');
        sb.append(this.dt == null ? "<null>" : this.dt);
        sb.append(',');
        sb.append("co");
        sb.append('=');
        sb.append(this.co == null ? "<null>" : this.co);
        sb.append(',');
        sb.append("is");
        sb.append('=');
        sb.append(this.is == null ? "<null>" : this.is);
        sb.append(',');
        sb.append("ci");
        sb.append('=');
        sb.append(this.ci == null ? "<null>" : this.ci);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.dt == null ? 0 : this.dt.hashCode());
        result = result * 31 + (this.sd == null ? 0 : this.sd.hashCode());
        result = result * 31 + (this.tg == null ? 0 : this.tg.hashCode());
        result = result * 31 + (this.mp == null ? 0 : this.mp.hashCode());
        result = result * 31 + (this.ma == null ? 0 : this.ma.hashCode());
        result = result * 31 + (this.ci == null ? 0 : this.ci.hashCode());
        result = result * 31 + (this.vp == null ? 0 : this.vp.hashCode());
        result = result * 31 + (this.dn == null ? 0 : this.dn.hashCode());
        result = result * 31 + (this.is == null ? 0 : this.is.hashCode());
        result = result * 31 + (this.co == null ? 0 : this.co.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof VaccinationEntry)) {
            return false;
        }
        VaccinationEntry rhs = (VaccinationEntry)other;
        return (this.dt == rhs.dt || this.dt != null && this.dt.equals(rhs.dt)) && (this.sd == rhs.sd || this.sd != null && this.sd.equals(rhs.sd)) && (this.tg == rhs.tg || this.tg != null && this.tg.equals(rhs.tg)) && (this.mp == rhs.mp || this.mp != null && this.mp.equals(rhs.mp)) && (this.ma == rhs.ma || this.ma != null && this.ma.equals(rhs.ma)) && (this.ci == rhs.ci || this.ci != null && this.ci.equals(rhs.ci)) && (this.vp == rhs.vp || this.vp != null && this.vp.equals(rhs.vp)) && (this.dn == rhs.dn || this.dn != null && this.dn.equals(rhs.dn)) && (this.is == rhs.is || this.is != null && this.is.equals(rhs.is)) && (this.co == rhs.co || this.co != null && this.co.equals(rhs.co));
    }
}

