/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.transliteration;

import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;

public class MrzEncoder {
    public static final int LENGTH_RESTRICTION = 80;
    public static final Map<Character, String> CHAR_MAPPINGS = new HashMap<Character, String>();

    public static String encode(String input) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.trim().length(); ++i) {
            char c = input.charAt(i);
            String mapping = CHAR_MAPPINGS.get(Character.valueOf(c));
            if (mapping != null) {
                sb.append(mapping);
                continue;
            }
            if (c == '\u2019' || c == '\'') continue;
            if (Character.isWhitespace(c)) {
                sb.append('<');
                continue;
            }
            sb.append(c);
        }
        String mrz = Normalizer.normalize(sb.toString(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").toUpperCase().replaceAll("[^<A-Z0-9]", "<");
        if (mrz.length() > 80 && (mrz = mrz.substring(0, 80)).endsWith("<")) {
            mrz = mrz.substring(0, 79);
        }
        return mrz;
    }

    static {
        CHAR_MAPPINGS.put(Character.valueOf('\u00e5'), "AA");
        CHAR_MAPPINGS.put(Character.valueOf('\u00c5'), "AA");
        CHAR_MAPPINGS.put(Character.valueOf('\u00e4'), "AE");
        CHAR_MAPPINGS.put(Character.valueOf('\u00c4'), "AE");
        CHAR_MAPPINGS.put(Character.valueOf('\u00c6'), "AE");
        CHAR_MAPPINGS.put(Character.valueOf('\u00e6'), "AE");
        CHAR_MAPPINGS.put(Character.valueOf('\u00f6'), "OE");
        CHAR_MAPPINGS.put(Character.valueOf('\u00d6'), "OE");
        CHAR_MAPPINGS.put(Character.valueOf('\u00f8'), "OE");
        CHAR_MAPPINGS.put(Character.valueOf('\u00d8'), "OE");
        CHAR_MAPPINGS.put(Character.valueOf('\u0132'), "IJ");
        CHAR_MAPPINGS.put(Character.valueOf('\u0133'), "IJ");
        CHAR_MAPPINGS.put(Character.valueOf('\u00dc'), "UE");
        CHAR_MAPPINGS.put(Character.valueOf('\u00fc'), "UE");
        CHAR_MAPPINGS.put(Character.valueOf('\u00df'), "SS");
        CHAR_MAPPINGS.put(Character.valueOf('\u0153'), "OE");
        CHAR_MAPPINGS.put(Character.valueOf('\u0152'), "OE");
        CHAR_MAPPINGS.put(Character.valueOf('\u00d0'), "D");
    }
}

