/*
 * Decompiled with CFR 0.152.
 */
package se.digg.dgc.valueset.v1;

import java.io.IOException;
import java.io.UncheckedIOException;
import se.digg.dgc.valueset.v1.ValueSet;

public class ValueSetConstants {
    public static final String DISEASE_AGENT_TARGETED_ID = "disease-agent-targeted";
    public static final String TEST_MANUFACTURER_AND_NAME_ID = "covid-19-lab-test-manufacturer-and-name";
    public static final String LAB_RESULT_ID = "covid-19-lab-result";
    public static final String TEST_TYPE = "covid-19-lab-test-type";
    public static final String MARKETING_AUTH_HOLDERS_ID = "vaccines-covid-19-auth-holders";
    public static final String MEDICAL_PRODUCT_ID = "vaccines-covid-19-names";
    public static final String VACCINE_PROPHYLAXIS = "sct-vaccines-covid-19";
    public static final String COUNTRY_CODES = "country-2-codes";

    public static ValueSet diseaseAgentTargeted() {
        return ValueSetConstants.createValueSet("/v1-valuesets/disease-agent-targeted.json");
    }

    public static ValueSet testManufacturer() {
        return ValueSetConstants.createValueSet("/v1-valuesets/test-manf.json");
    }

    public static ValueSet testResult() {
        return ValueSetConstants.createValueSet("/v1-valuesets/test-result.json");
    }

    public static ValueSet testType() {
        return ValueSetConstants.createValueSet("/v1-valuesets/test-type.json");
    }

    public static ValueSet marketingAuthorizationHolder() {
        return ValueSetConstants.createValueSet("/v1-valuesets/vaccine-mah-manf.json");
    }

    public static ValueSet medicalProduct() {
        return ValueSetConstants.createValueSet("/v1-valuesets/vaccine-medicinal-product.json");
    }

    public static ValueSet vaccineProphylaxis() {
        return ValueSetConstants.createValueSet("/v1-valuesets/vaccine-prophylaxis.json");
    }

    public static ValueSet countryCodes() {
        return ValueSetConstants.createValueSet("/v1-valuesets/country-2-codes.json");
    }

    private ValueSetConstants() {
    }

    private static ValueSet createValueSet(String classpathResource) {
        try {
            return new ValueSet(ValueSetConstants.class.getResourceAsStream(classpathResource));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

