/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.sprinkles;

import android.database.Cursor;
import java.util.Iterator;
import se.emilsjolander.sprinkles.QueryResult;
import se.emilsjolander.sprinkles.Utils;

class CursorIterator<T extends QueryResult>
implements Iterator<T> {
    private Cursor cursor;
    private Class<T> type;
    private int pos = -1;
    private int count;

    CursorIterator(Cursor cursor, Class<T> type) {
        this.cursor = cursor;
        this.type = type;
        this.count = cursor == null ? 0 : cursor.getCount();
    }

    @Override
    public boolean hasNext() {
        return this.pos + 1 < this.count;
    }

    @Override
    public T next() {
        ++this.pos;
        this.cursor.moveToPosition(this.pos);
        return Utils.getResultFromCursor(this.type, this.cursor);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

