/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.sprinkles;

import android.database.Cursor;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.emilsjolander.sprinkles.CursorIterator;
import se.emilsjolander.sprinkles.QueryResult;
import se.emilsjolander.sprinkles.Utils;

public class CursorList<T extends QueryResult>
implements Iterable<T>,
Closeable {
    private Cursor cursor;
    private Class<T> type;
    private boolean closed;

    CursorList(Cursor cursor, Class<T> type) {
        this.cursor = cursor;
        this.type = type;
    }

    public int size() {
        return this.cursor == null ? 0 : this.cursor.getCount();
    }

    public T get(int pos) {
        this.requireOpen();
        this.cursor.moveToPosition(pos);
        return Utils.getResultFromCursor(this.type, this.cursor);
    }

    public List<T> asList() {
        ArrayList<QueryResult> l = new ArrayList<QueryResult>(this.size());
        for (QueryResult t : this) {
            l.add(t);
        }
        return l;
    }

    @Override
    public Iterator<T> iterator() {
        return new CursorIterator<T>(this.cursor, this.type);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.closed = true;
    }

    private void requireOpen() {
        if (this.closed) {
            throw new IllegalStateException("Cannot call methods on a closed CursorList");
        }
    }
}

