/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.sprinkles;

import android.annotation.TargetApi;
import android.content.AsyncTaskLoader;
import android.content.Context;
import android.content.Loader;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import se.emilsjolander.sprinkles.Model;
import se.emilsjolander.sprinkles.Sprinkles;
import se.emilsjolander.sprinkles.Utils;

@TargetApi(value=11)
class CursorLoader
extends AsyncTaskLoader<Cursor> {
    private final Loader.ForceLoadContentObserver mObserver = new Loader.ForceLoadContentObserver((Loader)this);
    private String mSql;
    private Class<? extends Model>[] mDependencies;
    private Cursor mCursor;

    public CursorLoader(Context context, String sql, Class<? extends Model>[] dependencies) {
        super(context);
        this.mSql = sql;
        this.mDependencies = dependencies;
    }

    public Cursor loadInBackground() {
        SQLiteDatabase db = Sprinkles.getDatabase();
        Cursor cursor = db.rawQuery(this.mSql, null);
        if (cursor != null) {
            cursor.getCount();
            if (this.mDependencies != null) {
                cursor.registerContentObserver((ContentObserver)this.mObserver);
                for (Class<? extends Model> dependency : this.mDependencies) {
                    this.getContext().getContentResolver().registerContentObserver(Utils.getNotificationUri(dependency), false, (ContentObserver)this.mObserver);
                }
            }
        }
        return cursor;
    }

    public void deliverResult(Cursor cursor) {
        if (this.isReset()) {
            if (cursor != null) {
                cursor.close();
            }
            return;
        }
        Cursor oldCursor = this.mCursor;
        this.mCursor = cursor;
        if (this.isStarted()) {
            super.deliverResult((Object)cursor);
        }
        if (oldCursor != null && oldCursor != cursor && !oldCursor.isClosed()) {
            oldCursor.close();
        }
    }

    protected void onStartLoading() {
        if (this.mCursor != null) {
            this.deliverResult(this.mCursor);
        }
        if (this.takeContentChanged() || this.mCursor == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    public void onCanceled(Cursor cursor) {
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
    }

    protected void onAbandon() {
        super.onAbandon();
        this.getContext().getContentResolver().unregisterContentObserver((ContentObserver)this.mObserver);
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
        if (this.mCursor != null && !this.mCursor.isClosed()) {
            this.mCursor.close();
        }
        this.mCursor = null;
    }
}

