/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.sprinkles;

import android.annotation.TargetApi;
import android.app.LoaderManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import se.emilsjolander.sprinkles.CursorList;
import se.emilsjolander.sprinkles.CursorLoader;
import se.emilsjolander.sprinkles.Model;
import se.emilsjolander.sprinkles.QueryResult;
import se.emilsjolander.sprinkles.Sprinkles;
import se.emilsjolander.sprinkles.SupportCursorLoader;
import se.emilsjolander.sprinkles.Utils;

public final class ManyQuery<T extends QueryResult> {
    Class<T> resultClass;
    String placeholderQuery;
    String rawQuery;

    ManyQuery() {
    }

    public CursorList<T> get() {
        SQLiteDatabase db = Sprinkles.getDatabase();
        Cursor c = db.rawQuery(this.rawQuery, null);
        return new CursorList<T>(c, this.resultClass);
    }

    @TargetApi(value=11)
    public int getAsync(LoaderManager lm, ResultHandler<T> handler, Class<? extends Model> ... respondsToUpdatedOf) {
        if (Model.class.isAssignableFrom(this.resultClass)) {
            respondsToUpdatedOf = Utils.concatArrays(respondsToUpdatedOf, new Class[]{this.resultClass});
        }
        int loaderId = this.placeholderQuery.hashCode();
        lm.restartLoader(loaderId, null, this.getLoaderCallbacks(this.rawQuery, this.resultClass, handler, respondsToUpdatedOf));
        return loaderId;
    }

    public int getAsync(android.support.v4.app.LoaderManager lm, ResultHandler<T> handler, Class<? extends Model> ... respondsToUpdatedOf) {
        if (Model.class.isAssignableFrom(this.resultClass)) {
            respondsToUpdatedOf = Utils.concatArrays(respondsToUpdatedOf, new Class[]{this.resultClass});
        }
        int loaderId = this.placeholderQuery.hashCode();
        lm.restartLoader(loaderId, null, this.getSupportLoaderCallbacks(this.rawQuery, this.resultClass, handler, respondsToUpdatedOf));
        return loaderId;
    }

    @TargetApi(value=11)
    private LoaderManager.LoaderCallbacks<Cursor> getLoaderCallbacks(final String sqlQuery, final Class<T> resultClass, final ResultHandler<T> handler, final Class<? extends Model>[] respondsToUpdatedOf) {
        return new LoaderManager.LoaderCallbacks<Cursor>(){

            public void onLoaderReset(android.content.Loader<Cursor> loader) {
                if (!loader.isAbandoned()) {
                    handler.handleResult(new CursorList(null, null));
                }
            }

            public void onLoadFinished(android.content.Loader<Cursor> loader, Cursor c) {
                if (!handler.handleResult(new CursorList(c, resultClass))) {
                    loader.abandon();
                }
            }

            public android.content.Loader<Cursor> onCreateLoader(int id, Bundle args) {
                return new CursorLoader(Sprinkles.sInstance.mContext, sqlQuery, respondsToUpdatedOf);
            }
        };
    }

    private LoaderManager.LoaderCallbacks<Cursor> getSupportLoaderCallbacks(final String sqlQuery, final Class<T> resultClass, final ResultHandler<T> handler, final Class<? extends Model>[] respondsToUpdatedOf) {
        return new LoaderManager.LoaderCallbacks<Cursor>(){

            public void onLoaderReset(Loader<Cursor> loader) {
                if (!loader.isAbandoned()) {
                    handler.handleResult(new CursorList(null, null));
                }
            }

            public void onLoadFinished(Loader<Cursor> loader, Cursor c) {
                if (!handler.handleResult(new CursorList(c, resultClass))) {
                    loader.abandon();
                }
            }

            public Loader<Cursor> onCreateLoader(int id, Bundle args) {
                return new SupportCursorLoader(Sprinkles.sInstance.mContext, sqlQuery, respondsToUpdatedOf);
            }
        };
    }

    public static interface ResultHandler<T extends QueryResult> {
        public boolean handleResult(CursorList<T> var1);
    }
}

