/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.sprinkles;

import android.content.ContentValues;
import android.os.AsyncTask;
import se.emilsjolander.sprinkles.ModelInfo;
import se.emilsjolander.sprinkles.Query;
import se.emilsjolander.sprinkles.QueryResult;
import se.emilsjolander.sprinkles.Sprinkles;
import se.emilsjolander.sprinkles.Transaction;
import se.emilsjolander.sprinkles.Utils;
import se.emilsjolander.sprinkles.exceptions.ContentValuesEmptyException;

public abstract class Model
implements QueryResult {
    public boolean isValid() {
        return true;
    }

    protected void beforeCreate() {
    }

    protected void beforeSave() {
    }

    protected void afterDelete() {
    }

    public final boolean exists() {
        Model m = (Model)Query.one(this.getClass(), String.format("SELECT * FROM %s WHERE %s LIMIT 1", Utils.getTableName(this.getClass()), Utils.getWhereStatement(this)), new Object[0]).get();
        return m != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean save() {
        Transaction t = new Transaction();
        try {
            t.setSuccessful(this.save(t));
        }
        finally {
            t.finish();
        }
        return t.isSuccessful();
    }

    public final boolean save(Transaction t) {
        if (!this.isValid()) {
            return false;
        }
        boolean doesExist = this.exists();
        if (!doesExist) {
            this.beforeCreate();
        }
        this.beforeSave();
        ContentValues cv = Utils.getContentValues(this);
        if (cv.size() == 0) {
            throw new ContentValuesEmptyException();
        }
        String tableName = Utils.getTableName(this.getClass());
        if (doesExist) {
            if (t.update(tableName, cv, Utils.getWhereStatement(this)) == 0) {
                return false;
            }
        } else {
            long id = t.insert(tableName, cv);
            if (id == -1L) {
                return false;
            }
            ModelInfo info = ModelInfo.from(this.getClass());
            if (info.autoIncrementField != null) {
                info.autoIncrementField.field.setAccessible(true);
                try {
                    info.autoIncrementField.field.set(this, id);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        t.addOnTransactionCommittedListener(new Transaction.OnTransactionCommittedListener(){

            @Override
            public void onTransactionCommitted() {
                Sprinkles.sInstance.mContext.getContentResolver().notifyChange(Utils.getNotificationUri(Model.this.getClass()), null, true);
            }
        });
        return true;
    }

    public final void saveAsync() {
        this.saveAsync(null);
    }

    public final void saveAsync(final OnSavedCallback callback) {
        new AsyncTask<Model, Void, Boolean>(){

            protected Boolean doInBackground(Model ... params) {
                return params[0].save();
            }

            protected void onPostExecute(Boolean result) {
                if (result.booleanValue() && callback != null) {
                    callback.onSaved();
                }
            }
        }.execute((Object[])new Model[]{this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete() {
        Transaction t = new Transaction();
        try {
            this.delete(t);
            t.setSuccessful(true);
        }
        finally {
            t.finish();
        }
    }

    public final void delete(Transaction t) {
        t.delete(Utils.getTableName(this.getClass()), Utils.getWhereStatement(this));
        t.addOnTransactionCommittedListener(new Transaction.OnTransactionCommittedListener(){

            @Override
            public void onTransactionCommitted() {
                Sprinkles.sInstance.mContext.getContentResolver().notifyChange(Utils.getNotificationUri(Model.this.getClass()), null);
            }
        });
        this.afterDelete();
    }

    public final void deleteAsync() {
        this.deleteAsync(null);
    }

    public final void deleteAsync(final OnDeletedCallback callback) {
        new AsyncTask<Model, Void, Void>(){

            protected Void doInBackground(Model ... params) {
                params[0].delete();
                return null;
            }

            protected void onPostExecute(Void result) {
                if (callback != null) {
                    callback.onDeleted();
                }
            }
        }.execute((Object[])new Model[]{this});
    }

    public static interface OnDeletedCallback {
        public void onDeleted();
    }

    public static interface OnSavedCallback {
        public void onSaved();
    }
}

