/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.sprinkles;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import se.emilsjolander.sprinkles.Model;
import se.emilsjolander.sprinkles.QueryResult;
import se.emilsjolander.sprinkles.Sprinkles;
import se.emilsjolander.sprinkles.Utils;
import se.emilsjolander.sprinkles.annotations.AutoIncrement;
import se.emilsjolander.sprinkles.annotations.Column;
import se.emilsjolander.sprinkles.annotations.DynamicColumn;
import se.emilsjolander.sprinkles.annotations.Key;
import se.emilsjolander.sprinkles.exceptions.AutoIncrementMustBeIntegerException;
import se.emilsjolander.sprinkles.exceptions.DuplicateColumnException;
import se.emilsjolander.sprinkles.exceptions.EmptyTableException;
import se.emilsjolander.sprinkles.exceptions.NoKeysException;
import se.emilsjolander.sprinkles.typeserializers.SqlType;

class ModelInfo {
    private static Map<Class<? extends QueryResult>, ModelInfo> cache = new HashMap<Class<? extends QueryResult>, ModelInfo>();
    String tableName;
    Set<ColumnField> columns = new HashSet<ColumnField>();
    List<ColumnField> keys = new ArrayList<ColumnField>();
    ColumnField autoIncrementField;

    private ModelInfo() {
    }

    static ModelInfo from(Class<? extends QueryResult> clazz) {
        Field[] fields;
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        ModelInfo info = new ModelInfo();
        for (Field field : fields = Utils.getAllDeclaredFields(clazz, Object.class)) {
            ColumnField column;
            if (field.isAnnotationPresent(DynamicColumn.class)) {
                column = new ColumnField();
                column.isDynamic = true;
                column.name = field.getAnnotation(DynamicColumn.class).value();
                column.sqlType = Sprinkles.sInstance.getTypeSerializer(field.getType()).getSqlType().name();
                column.field = field;
                if (info.columns.add(column)) continue;
                throw new DuplicateColumnException(column.name);
            }
            if (!field.isAnnotationPresent(Column.class)) continue;
            column = new ColumnField();
            column.isAutoIncrement = field.isAnnotationPresent(AutoIncrement.class);
            column.isKey = field.isAnnotationPresent(Key.class) || column.isAutoIncrement;
            column.name = field.getAnnotation(Column.class).value();
            column.sqlType = Sprinkles.sInstance.getTypeSerializer(field.getType()).getSqlType().name();
            column.field = field;
            if (column.isAutoIncrement && !column.sqlType.equals(SqlType.INTEGER.name())) {
                throw new AutoIncrementMustBeIntegerException(column.name);
            }
            if (column.isAutoIncrement) {
                info.autoIncrementField = column;
            }
            if (column.isKey) {
                info.keys.add(column);
            }
            if (info.columns.add(column)) continue;
            throw new DuplicateColumnException(column.name);
        }
        if (info.columns.isEmpty()) {
            throw new EmptyTableException(clazz.getName());
        }
        if (Model.class.isAssignableFrom(clazz)) {
            info.tableName = Utils.getTableName(clazz);
            if (info.keys.size() == 0) {
                throw new NoKeysException();
            }
        }
        cache.put(clazz, info);
        return info;
    }

    public static class ColumnField {
        String name;
        String sqlType;
        Field field;
        boolean isKey;
        boolean isAutoIncrement;
        boolean isDynamic;

        public boolean equals(Object o) {
            if (o instanceof ColumnField) {
                return ((ColumnField)o).name.equals(this.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

