/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.sprinkles;

import android.os.AsyncTask;
import java.util.ArrayList;
import java.util.Collection;
import se.emilsjolander.sprinkles.CursorList;
import se.emilsjolander.sprinkles.Model;
import se.emilsjolander.sprinkles.Transaction;

public class ModelList<E extends Model>
extends ArrayList<E> {
    private static final long serialVersionUID = 9111033070491580889L;

    public static <E extends Model> ModelList<E> from(CursorList<E> cursorList) {
        return new ModelList<E>(cursorList.asList());
    }

    public ModelList() {
    }

    public ModelList(int capacity) {
        super(capacity);
    }

    public ModelList(Collection<? extends E> collection) {
        super(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAll() {
        Transaction t = new Transaction();
        try {
            t.setSuccessful(this.saveAll(t));
        }
        finally {
            t.finish();
        }
        return t.isSuccessful();
    }

    public boolean saveAll(Transaction t) {
        for (Model m : this) {
            if (m.save(t)) continue;
            return false;
        }
        return true;
    }

    public void saveAllAsync() {
        this.saveAllAsync(null);
    }

    public void saveAllAsync(final OnAllSavedCallback callback) {
        new AsyncTask<Void, Void, Boolean>(){

            protected Boolean doInBackground(Void ... params) {
                return ModelList.this.saveAll();
            }

            protected void onPostExecute(Boolean result) {
                if (result.booleanValue() && callback != null) {
                    callback.onAllSaved();
                }
            }
        }.execute((Object[])new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Transaction t = new Transaction();
        try {
            this.deleteAll(t);
            t.setSuccessful(true);
        }
        finally {
            t.finish();
        }
    }

    public void deleteAll(Transaction t) {
        for (Model m : this) {
            m.delete(t);
        }
    }

    public void deleteAllAsync() {
        this.deleteAllAsync(null);
    }

    public void deleteAllAsync(final OnAllDeletedCallback callback) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                ModelList.this.deleteAll();
                return null;
            }

            protected void onPostExecute(Void result) {
                if (callback != null) {
                    callback.onAllDeleted();
                }
            }
        }.execute((Object[])new Void[0]);
    }

    public static interface OnAllDeletedCallback {
        public void onAllDeleted();
    }

    public static interface OnAllSavedCallback {
        public void onAllSaved();
    }
}

