/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.sprinkles;

import se.emilsjolander.sprinkles.ManyQuery;
import se.emilsjolander.sprinkles.Model;
import se.emilsjolander.sprinkles.OneQuery;
import se.emilsjolander.sprinkles.QueryResult;
import se.emilsjolander.sprinkles.Utils;

public final class Query {
    private Query() {
    }

    public static <T extends QueryResult> OneQuery<T> one(Class<T> clazz, String sql, Object ... sqlArgs) {
        OneQuery query = new OneQuery();
        query.resultClass = clazz;
        query.placeholderQuery = sql;
        query.rawQuery = Utils.insertSqlArgs(sql, sqlArgs);
        return query;
    }

    public static <T extends QueryResult> OneQuery<T> one(Class<T> clazz, int sqlResId, Object ... sqlArgs) {
        String sql = Utils.readRawText(sqlResId);
        return Query.one(clazz, sql, sqlArgs);
    }

    public static <T extends QueryResult> ManyQuery<T> many(Class<T> clazz, String sql, Object ... sqlArgs) {
        ManyQuery query = new ManyQuery();
        query.resultClass = clazz;
        query.placeholderQuery = sql;
        query.rawQuery = Utils.insertSqlArgs(sql, sqlArgs);
        return query;
    }

    public static <T extends QueryResult> ManyQuery<T> many(Class<T> clazz, int sqlResId, Object ... sqlArgs) {
        String sql = Utils.readRawText(sqlResId);
        return Query.many(clazz, sql, sqlArgs);
    }

    public static <T extends Model> ManyQuery<T> all(Class<T> clazz) {
        return Query.many(clazz, "SELECT * FROM " + Utils.getTableName(clazz), new Object[0]);
    }
}

