/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.sprinkles;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import se.emilsjolander.sprinkles.DbOpenHelper;
import se.emilsjolander.sprinkles.Migration;
import se.emilsjolander.sprinkles.exceptions.NoTypeSerializerFoundException;
import se.emilsjolander.sprinkles.exceptions.SprinklesNotInitializedException;
import se.emilsjolander.sprinkles.typeserializers.BitmapSerializer;
import se.emilsjolander.sprinkles.typeserializers.BooleanSerializer;
import se.emilsjolander.sprinkles.typeserializers.DateSerializer;
import se.emilsjolander.sprinkles.typeserializers.DoubleSerializer;
import se.emilsjolander.sprinkles.typeserializers.FloatSerializer;
import se.emilsjolander.sprinkles.typeserializers.IntSerializer;
import se.emilsjolander.sprinkles.typeserializers.LongSerializer;
import se.emilsjolander.sprinkles.typeserializers.StringSerializer;
import se.emilsjolander.sprinkles.typeserializers.TypeSerializer;

public final class Sprinkles {
    static Sprinkles sInstance;
    static SQLiteDatabase sDatabase;
    Context mContext;
    List<Migration> mMigrations = new ArrayList<Migration>();
    private String databaseName;
    private int initialDatabaseVersion;
    private Map<Class, TypeSerializer> typeSerializers = new ConcurrentHashMap<Class, TypeSerializer>();

    private Sprinkles() {
        this.addStandardTypeSerializers();
    }

    private void addStandardTypeSerializers() {
        this.typeSerializers.put(Integer.TYPE, new IntSerializer());
        this.typeSerializers.put(Integer.class, new IntSerializer());
        this.typeSerializers.put(Long.TYPE, new LongSerializer());
        this.typeSerializers.put(Long.class, new LongSerializer());
        this.typeSerializers.put(Float.TYPE, new FloatSerializer());
        this.typeSerializers.put(Float.class, new FloatSerializer());
        this.typeSerializers.put(Double.TYPE, new DoubleSerializer());
        this.typeSerializers.put(Double.class, new DoubleSerializer());
        this.typeSerializers.put(Boolean.TYPE, new BooleanSerializer());
        this.typeSerializers.put(Boolean.class, new BooleanSerializer());
        this.typeSerializers.put(String.class, new StringSerializer());
        this.typeSerializers.put(Date.class, new DateSerializer());
        this.typeSerializers.put(Bitmap.class, new BitmapSerializer());
    }

    public static synchronized Sprinkles init(Context context) {
        return Sprinkles.init(context, "sprinkles.db", 0);
    }

    public static synchronized Sprinkles init(Context context, String databaseName, int initialDatabaseVersion) {
        if (sInstance == null) {
            sInstance = new Sprinkles();
        }
        Sprinkles.sInstance.mContext = context.getApplicationContext();
        Sprinkles.sInstance.databaseName = databaseName;
        Sprinkles.sInstance.initialDatabaseVersion = initialDatabaseVersion;
        return sInstance;
    }

    @Deprecated
    public static synchronized Sprinkles getInstance(Context context) {
        return Sprinkles.init(context);
    }

    static synchronized SQLiteDatabase getDatabase() {
        if (sInstance == null) {
            throw new SprinklesNotInitializedException();
        }
        if (sDatabase == null) {
            DbOpenHelper dbOpenHelper = new DbOpenHelper(Sprinkles.sInstance.mContext, Sprinkles.sInstance.databaseName, Sprinkles.sInstance.initialDatabaseVersion);
            sDatabase = dbOpenHelper.getWritableDatabase();
        }
        return sDatabase;
    }

    public static synchronized void dropInstances() {
        sInstance = null;
        sDatabase = null;
    }

    public void addMigration(Migration migration) {
        this.mMigrations.add(migration);
    }

    public <T> void registerType(Class<T> clazz, TypeSerializer<T> serializer) {
        this.typeSerializers.put(clazz, serializer);
    }

    TypeSerializer getTypeSerializer(Class<?> type) {
        if (!this.typeSerializers.containsKey(type)) {
            throw new NoTypeSerializerFoundException(type);
        }
        return this.typeSerializers.get(type);
    }
}

