/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.sprinkles;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.List;
import se.emilsjolander.sprinkles.Sprinkles;

public final class Transaction {
    private SQLiteDatabase mDb;
    private boolean mSuccessful;
    private List<OnTransactionCommittedListener> mOnTransactionCommittedListeners = new ArrayList<OnTransactionCommittedListener>();

    public Transaction() {
        this.mDb = Sprinkles.getDatabase();
        this.mDb.beginTransaction();
    }

    public void setSuccessful(boolean successful) {
        this.mSuccessful = successful;
    }

    public boolean isSuccessful() {
        return this.mSuccessful;
    }

    public void finish() {
        if (this.mSuccessful) {
            this.mDb.setTransactionSuccessful();
        }
        this.mDb.endTransaction();
        if (this.mSuccessful) {
            for (OnTransactionCommittedListener listener : this.mOnTransactionCommittedListeners) {
                listener.onTransactionCommitted();
            }
        }
    }

    long insert(String table, ContentValues values) {
        return this.mDb.insert(table, null, values);
    }

    int update(String table, ContentValues values, String where) {
        return this.mDb.update(table, values, where, null);
    }

    int delete(String table, String where) {
        return this.mDb.delete(table, where, null);
    }

    void addOnTransactionCommittedListener(OnTransactionCommittedListener listener) {
        this.mOnTransactionCommittedListeners.add(listener);
    }

    static interface OnTransactionCommittedListener {
        public void onTransactionCommitted();
    }
}

