/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.sprinkles;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import se.emilsjolander.sprinkles.Model;
import se.emilsjolander.sprinkles.ModelInfo;
import se.emilsjolander.sprinkles.QueryResult;
import se.emilsjolander.sprinkles.Sprinkles;
import se.emilsjolander.sprinkles.annotations.Table;
import se.emilsjolander.sprinkles.exceptions.NoTableAnnotationException;
import se.emilsjolander.sprinkles.typeserializers.TypeSerializer;

class Utils {
    Utils() {
    }

    static <T extends QueryResult> T getResultFromCursor(Class<T> resultClass, Cursor c) {
        try {
            ModelInfo info = ModelInfo.from(resultClass);
            QueryResult result = (QueryResult)resultClass.newInstance();
            List<String> colNames = Arrays.asList(c.getColumnNames());
            for (ModelInfo.ColumnField column : info.columns) {
                if (!colNames.contains(column.name)) continue;
                column.field.setAccessible(true);
                Class<?> type = column.field.getType();
                Object o = Sprinkles.sInstance.getTypeSerializer(type).unpack(c, column.name);
                column.field.set(result, o);
            }
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String getWhereStatement(Model m) {
        ModelInfo info = ModelInfo.from(m.getClass());
        StringBuilder where = new StringBuilder();
        Object[] args = new Object[info.keys.size()];
        for (int i = 0; i < info.keys.size(); ++i) {
            ModelInfo.ColumnField column = info.keys.get(i);
            where.append(column.name);
            where.append("=?");
            column.field.setAccessible(true);
            try {
                args[i] = column.field.get(m);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (i >= info.keys.size() - 1) continue;
            where.append(" AND ");
        }
        return Utils.insertSqlArgs(where.toString(), args);
    }

    static ContentValues getContentValues(Model model) {
        ModelInfo info = ModelInfo.from(model.getClass());
        ContentValues values = new ContentValues();
        for (ModelInfo.ColumnField column : info.columns) {
            Object value;
            if (column.isAutoIncrement || column.isDynamic) continue;
            column.field.setAccessible(true);
            try {
                value = column.field.get(model);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Sprinkles.sInstance.getTypeSerializer(column.field.getType()).pack(value, values, column.name);
        }
        return values;
    }

    static <T extends Model> Uri getNotificationUri(Class<T> clazz) {
        return Uri.parse((String)("sprinkles://" + Utils.getTableName(clazz)));
    }

    static String getTableName(Class<? extends Model> clazz) {
        if (clazz.isAnnotationPresent(Table.class)) {
            return clazz.getAnnotation(Table.class).value();
        }
        throw new NoTableAnnotationException();
    }

    static String insertSqlArgs(String sql, Object[] args) {
        if (args == null) {
            return sql;
        }
        for (Object o : args) {
            TypeSerializer typeSerializer = Sprinkles.sInstance.getTypeSerializer(o.getClass());
            String sqlObject = typeSerializer.toSql(o);
            sql = sql.replaceFirst("\\?", sqlObject);
        }
        return sql;
    }

    static Field[] getAllDeclaredFields(Class<?> clazz, Class<?> stopAt) {
        Field[] result = new Field[]{};
        while (!clazz.equals(stopAt)) {
            result = Utils.concatArrays(result, clazz.getDeclaredFields());
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    static <T> T[] concatArrays(T[] one, T[] two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        int length = one.length + two.length;
        Object[] result = (Object[])Array.newInstance(one.getClass().getComponentType(), length);
        for (int i = 0; i < length; ++i) {
            result[i] = i < one.length ? one[i] : two[i - one.length];
        }
        return result;
    }

    static String readRawText(int rawId) {
        InputStream inputStream = Sprinkles.sInstance.mContext.getResources().openRawResource(rawId);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder body = new StringBuilder();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                body.append(line);
                body.append('\n');
            }
        }
        catch (IOException e) {
            return null;
        }
        return body.toString();
    }
}

