/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.stickylistheaders;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import java.util.List;
import se.emilsjolander.stickylistheaders.ExpandableStickyListHeadersAdapter;
import se.emilsjolander.stickylistheaders.StickyListHeadersAdapter;
import se.emilsjolander.stickylistheaders.StickyListHeadersListView;

public class ExpandableStickyListHeadersListView
extends StickyListHeadersListView {
    public static final int ANIMATION_COLLAPSE = 1;
    public static final int ANIMATION_EXPAND = 0;
    ExpandableStickyListHeadersAdapter mExpandableStickyListHeadersAdapter;
    IAnimationExecutor mDefaultAnimExecutor = new IAnimationExecutor(){

        @Override
        public void executeAnim(View target, int animType) {
            if (animType == 0) {
                target.setVisibility(0);
            } else if (animType == 1) {
                target.setVisibility(8);
            }
        }
    };

    public ExpandableStickyListHeadersListView(Context context) {
        super(context);
    }

    public ExpandableStickyListHeadersListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ExpandableStickyListHeadersListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public ExpandableStickyListHeadersAdapter getAdapter() {
        return this.mExpandableStickyListHeadersAdapter;
    }

    @Override
    public void setAdapter(StickyListHeadersAdapter adapter) {
        this.mExpandableStickyListHeadersAdapter = new ExpandableStickyListHeadersAdapter(adapter);
        super.setAdapter(this.mExpandableStickyListHeadersAdapter);
    }

    public View findViewByItemId(long itemId) {
        return this.mExpandableStickyListHeadersAdapter.findViewByItemId(itemId);
    }

    public long findItemIdByView(View view) {
        return this.mExpandableStickyListHeadersAdapter.findItemIdByView(view);
    }

    public void expand(long headerId) {
        if (!this.mExpandableStickyListHeadersAdapter.isHeaderCollapsed(headerId)) {
            return;
        }
        this.mExpandableStickyListHeadersAdapter.expand(headerId);
        List<View> itemViews = this.mExpandableStickyListHeadersAdapter.getItemViewsByHeaderId(headerId);
        if (itemViews == null) {
            return;
        }
        for (View view : itemViews) {
            this.animateView(view, 0);
        }
    }

    public void collapse(long headerId) {
        if (this.mExpandableStickyListHeadersAdapter.isHeaderCollapsed(headerId)) {
            return;
        }
        this.mExpandableStickyListHeadersAdapter.collapse(headerId);
        List<View> itemViews = this.mExpandableStickyListHeadersAdapter.getItemViewsByHeaderId(headerId);
        if (itemViews == null) {
            return;
        }
        for (View view : itemViews) {
            this.animateView(view, 1);
        }
    }

    public boolean isHeaderCollapsed(long headerId) {
        return this.mExpandableStickyListHeadersAdapter.isHeaderCollapsed(headerId);
    }

    public void setAnimExecutor(IAnimationExecutor animExecutor) {
        this.mDefaultAnimExecutor = animExecutor;
    }

    private void animateView(View target, int type) {
        if (0 == type && target.getVisibility() == 0) {
            return;
        }
        if (1 == type && target.getVisibility() != 0) {
            return;
        }
        if (this.mDefaultAnimExecutor != null) {
            this.mDefaultAnimExecutor.executeAnim(target, type);
        }
    }

    public static interface IAnimationExecutor {
        public void executeAnim(View var1, int var2);
    }
}

