/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.stickylistheaders;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;

public class WrapperView
extends ViewGroup {
    View mItem;
    Drawable mDivider;
    int mDividerHeight;
    View mHeader;
    int mItemTop;

    WrapperView(Context c) {
        super(c);
    }

    public boolean hasHeader() {
        return this.mHeader != null;
    }

    public View getItem() {
        return this.mItem;
    }

    public View getHeader() {
        return this.mHeader;
    }

    void update(View item, View header, Drawable divider, int dividerHeight) {
        if (item == null) {
            throw new NullPointerException("List view item must not be null.");
        }
        if (this.mItem != item) {
            this.removeView(this.mItem);
            this.mItem = item;
            ViewParent parent = item.getParent();
            if (parent != null && parent != this && parent instanceof ViewGroup) {
                ((ViewGroup)parent).removeView(item);
            }
            this.addView(item);
        }
        if (this.mHeader != header) {
            if (this.mHeader != null) {
                this.removeView(this.mHeader);
            }
            this.mHeader = header;
            if (header != null) {
                this.addView(header);
            }
        }
        if (this.mDivider != divider) {
            this.mDivider = divider;
            this.mDividerHeight = dividerHeight;
            this.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ViewGroup.LayoutParams params;
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)measuredWidth, (int)0x40000000);
        int measuredHeight = 0;
        if (this.mHeader != null) {
            params = this.mHeader.getLayoutParams();
            if (params != null && params.height > 0) {
                this.mHeader.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)params.height, (int)0x40000000));
            } else {
                this.mHeader.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            }
            measuredHeight += this.mHeader.getMeasuredHeight();
        } else if (this.mDivider != null && this.mItem.getVisibility() != 8) {
            measuredHeight += this.mDividerHeight;
        }
        params = this.mItem.getLayoutParams();
        if (this.mItem.getVisibility() == 8) {
            this.mItem.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)0, (int)0x40000000));
        } else if (params != null && params.height >= 0) {
            this.mItem.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)params.height, (int)0x40000000));
            measuredHeight += this.mItem.getMeasuredHeight();
        } else {
            this.mItem.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            measuredHeight += this.mItem.getMeasuredHeight();
        }
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        l = 0;
        t = 0;
        r = this.getWidth();
        b = this.getHeight();
        if (this.mHeader != null) {
            int headerHeight = this.mHeader.getMeasuredHeight();
            this.mHeader.layout(l, t, r, headerHeight);
            this.mItemTop = headerHeight;
            this.mItem.layout(l, headerHeight, r, b);
        } else if (this.mDivider != null) {
            this.mDivider.setBounds(l, t, r, this.mDividerHeight);
            this.mItemTop = this.mDividerHeight;
            this.mItem.layout(l, this.mDividerHeight, r, b);
        } else {
            this.mItemTop = t;
            this.mItem.layout(l, t, r, b);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mHeader == null && this.mDivider != null && this.mItem.getVisibility() != 8) {
            if (Build.VERSION.SDK_INT < 11) {
                canvas.clipRect(0, 0, this.getWidth(), this.mDividerHeight);
            }
            this.mDivider.draw(canvas);
        }
    }
}

